/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model;

import java.util.List;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.platform.db.model.DBIndex;
import org.databene.platform.db.model.DBTable;
import org.databene.platform.db.model.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCatalog {
    private String name;
    private Database database;
    private OrderedNameMap<DBTable> tables;
    private OrderedNameMap<DBIndex> indexes;
    private String doc;

    public DBCatalog() {
        this(null);
    }

    public DBCatalog(String name) {
        this.name = name;
        this.tables = new OrderedNameMap();
        this.indexes = new OrderedNameMap();
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public List<DBTable> getTables() {
        return this.tables.values();
    }

    public DBTable getTable(String tableName) {
        return (DBTable)this.tables.get(tableName.toUpperCase());
    }

    public void addTable(DBTable table) {
        table.setCatalog(this);
        this.tables.put(table.getName().toUpperCase(), (Object)table);
    }

    public void removeTable(DBTable table) {
        this.tables.remove(table.getName());
    }

    public List<DBIndex> getIndexes() {
        return this.indexes.values();
    }

    public DBIndex getIndex(String indexName) {
        return (DBIndex)this.indexes.get(indexName);
    }

    public void addIndex(DBIndex index) {
        index.setCatalog(this);
        this.indexes.put(index.getName(), (Object)index);
    }

    public void removeIndex(DBIndex index) {
        this.indexes.remove(index.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBCatalog that = (DBCatalog)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

