/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model;

import java.util.ArrayList;
import java.util.List;
import org.databene.platform.db.model.DBColumnType;
import org.databene.platform.db.model.DBConstraint;
import org.databene.platform.db.model.DBNotNullConstraint;
import org.databene.platform.db.model.DBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBColumn {
    private String name;
    private DBColumnType type;
    private Integer size;
    private Integer fractionDigits;
    private String doc;
    private String defaultValue;
    private DBTable table;
    private boolean versionColumn;
    private List<DBConstraint> ukConstraints;
    private DBConstraint notNullConstraint;

    public DBColumn() {
        this(null, null);
    }

    public DBColumn(String name, DBColumnType type) {
        this(name, type, null);
    }

    public DBColumn(String name, DBColumnType type, Integer size) {
        this(name, type, size, null);
    }

    public DBColumn(String name, DBColumnType type, Integer size, Integer fractionDigits) {
        this(null, name, type, size, fractionDigits);
    }

    public DBColumn(DBTable table, String name, DBColumnType type, Integer size, Integer fractionDigits) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.size = size;
        this.fractionDigits = fractionDigits;
        this.doc = null;
        this.defaultValue = null;
        this.ukConstraints = new ArrayList<DBConstraint>();
        this.notNullConstraint = null;
        this.versionColumn = false;
    }

    public DBTable getTable() {
        return this.table;
    }

    public void setTable(DBTable table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public DBColumnType getType() {
        return this.type;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    public void setFractionDigits(Integer fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<DBConstraint> getUkConstraints() {
        return this.ukConstraints;
    }

    public void addUkConstraint(DBConstraint constraint) {
        this.ukConstraints.add(constraint);
    }

    public DBConstraint getNotNullConstraint() {
        return this.notNullConstraint;
    }

    public void setNotNullConstraint(DBConstraint notNullConstraint) {
        this.notNullConstraint = notNullConstraint;
    }

    public boolean isNullable() {
        return this.notNullConstraint == null;
    }

    public void setNullable(boolean nullable) {
        if (nullable) {
            this.notNullConstraint = null;
        } else if (this.isNullable()) {
            this.notNullConstraint = new DBNotNullConstraint(this);
        }
    }

    public boolean isVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(boolean versionColumn) {
        this.versionColumn = versionColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBColumn that = (DBColumn)o;
        return this.table.equals(that.table) && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.table.hashCode() * 29 + this.name.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name).append(" : ").append(this.type);
        if (this.size != null) {
            builder.append('(');
            builder.append(this.size);
            if (this.fractionDigits != null) {
                builder.append(",").append(this.fractionDigits);
            }
            builder.append(')');
        }
        if (!this.isNullable()) {
            builder.append(" NOT NULL");
        }
        return builder.toString();
    }

    public static String formatColumnNames(DBColumn[] columns) {
        StringBuilder builder = new StringBuilder(columns[0].getName());
        for (int i = 1; i < columns.length; ++i) {
            builder.append(", ").append(columns[i].getName());
        }
        return builder.toString();
    }

    public static String formatColumnNames(List<DBColumn> columns) {
        StringBuilder builder = new StringBuilder(columns.get(0).getName());
        for (int i = 1; i < columns.size(); ++i) {
            builder.append(", ").append(columns.get(i).getName());
        }
        return builder.toString();
    }
}

