/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model;

public class DBColumnType {
    private String name;
    private int jdbcType;

    public static DBColumnType getInstance(int jdbcType, String name) {
        return new DBColumnType(jdbcType, name.toUpperCase());
    }

    public static DBColumnType getInstance(String name) {
        return new DBColumnType(Integer.MIN_VALUE, name.toUpperCase());
    }

    private DBColumnType(int sqlType, String name) {
        this.jdbcType = sqlType;
        this.name = name.toUpperCase();
    }

    public String getName() {
        return this.name;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public boolean isLOB() {
        return "CLOB".equals(this.name) || "BLOB".equals(this.name);
    }

    public boolean isAlpha() {
        return this.jdbcType == 12 || this.jdbcType == 1 || this.jdbcType == 2005 || this.jdbcType == -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBColumnType that = (DBColumnType)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

