/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model;

import java.util.Arrays;
import org.databene.commons.ArrayFormat;
import org.databene.commons.bean.ArrayPropertyExtractor;
import org.databene.platform.db.model.DBColumn;
import org.databene.platform.db.model.DBTable;

public abstract class DBConstraint {
    protected String name;

    public DBConstraint(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract DBTable getOwner();

    public abstract DBColumn[] getColumns();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBConstraint that = (DBConstraint)o;
        return this.getOwner().equals(that.getOwner()) && Arrays.equals(this.getColumns(), that.getColumns());
    }

    public int hashCode() {
        return this.getOwner().hashCode() * 29 + Arrays.hashCode(this.getColumns());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append('[').append(this.getOwner().getName()).append('[');
        Object[] columnNames = (String[])ArrayPropertyExtractor.convert((Object[])this.getColumns(), (String)"name", String.class);
        builder.append(ArrayFormat.format((Object[])columnNames));
        builder.append("]]");
        return builder.toString();
    }
}

