/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model;

import java.util.List;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.platform.db.model.DBCatalog;
import org.databene.platform.db.model.DBTable;
import org.databene.platform.db.model.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchema {
    private Database database;
    private String name;
    private DBCatalog catalog;
    private OrderedNameMap<DBTable> tables;

    public DBSchema() {
        this(null);
    }

    public DBSchema(String name) {
        this(null, name);
    }

    public DBSchema(Database database, String name) {
        this.name = name;
        this.database = database;
        this.catalog = null;
        this.tables = new OrderedNameMap();
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getName() {
        return this.name;
    }

    public DBCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(DBCatalog catalog) {
        this.catalog = catalog;
    }

    public List<DBTable> getTables() {
        return this.tables.values();
    }

    public DBTable getTable(String tableName) {
        return (DBTable)this.tables.get(tableName.toUpperCase());
    }

    public void addTable(DBTable table) {
        this.tables.put(table.getName().toUpperCase(), (Object)table);
    }

    public void removeTable(DBTable table) {
        this.tables.remove(table.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBSchema that = (DBSchema)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

