/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.bean.ArrayPropertyExtractor;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.db.DBUtil;
import org.databene.model.depend.Dependent;
import org.databene.platform.db.model.DBCatalog;
import org.databene.platform.db.model.DBColumn;
import org.databene.platform.db.model.DBForeignKeyConstraint;
import org.databene.platform.db.model.DBIndex;
import org.databene.platform.db.model.DBPrimaryKeyConstraint;
import org.databene.platform.db.model.DBSchema;
import org.databene.platform.db.model.DBUniqueConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTable
implements Dependent<DBTable> {
    private DBCatalog catalog;
    private DBSchema schema;
    private String name;
    private String doc;
    private OrderedNameMap<DBColumn> columns;
    private DBPrimaryKeyConstraint primaryKeyConstraint;
    private List<DBUniqueConstraint> uniqueConstraints;
    private List<DBForeignKeyConstraint> foreignKeyConstraints;
    private OrderedNameMap<DBIndex> indexes;

    public DBTable() {
        this(null);
    }

    public DBTable(String name) {
        this(null, name);
    }

    public DBTable(DBCatalog catalog, String name) {
        this.name = name;
        this.catalog = catalog;
        this.columns = new OrderedNameMap();
        this.primaryKeyConstraint = null;
        this.doc = null;
        this.schema = null;
        this.indexes = new OrderedNameMap();
        this.uniqueConstraints = new ArrayList<DBUniqueConstraint>();
        this.foreignKeyConstraints = new ArrayList<DBForeignKeyConstraint>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public DBCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(DBCatalog catalog) {
        this.catalog = catalog;
    }

    public DBSchema getSchema() {
        return this.schema;
    }

    public void setSchema(DBSchema schema) {
        this.schema = schema;
    }

    public void setPrimaryKeyConstraint(DBPrimaryKeyConstraint constraint) {
        this.primaryKeyConstraint = constraint;
    }

    public DBPrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public List<DBColumn> getColumns() {
        return this.columns.values();
    }

    public DBColumn[] getColumns(List<String> columnNames) {
        ArrayList<DBColumn> list = new ArrayList<DBColumn>(columnNames.size());
        for (String columnName : columnNames) {
            DBColumn column = this.getColumn(columnName);
            if (column == null) {
                throw new IllegalArgumentException("Table '" + this.name + "' does not have a column '" + columnName + "'");
            }
            list.add(column);
        }
        DBColumn[] array = new DBColumn[columnNames.size()];
        return list.toArray(array);
    }

    public DBColumn getColumn(String columnName) {
        DBColumn column = (DBColumn)this.columns.get(columnName.toUpperCase());
        if (column == null) {
            throw new ObjectNotFoundException("Column '" + columnName + "' not found in table '" + this.getName() + "'");
        }
        return column;
    }

    public void addColumn(DBColumn column) {
        column.setTable(this);
        this.columns.put(column.getName().toUpperCase(), (Object)column);
    }

    public List<DBIndex> getIndexes() {
        return this.indexes.values();
    }

    public DBIndex getIndex(String indexName) {
        return (DBIndex)this.indexes.get(indexName);
    }

    public void addIndex(DBIndex index) {
        this.indexes.put(index.getName(), (Object)index);
    }

    public void removeIndex(DBIndex index) {
        this.indexes.remove(index.getName());
    }

    public List<DBUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void addUniqueConstraint(DBUniqueConstraint constraint) {
        this.uniqueConstraints.add(constraint);
    }

    public void removeUniqueConstraint(DBUniqueConstraint constraint) {
        this.uniqueConstraints.remove(constraint);
    }

    public List<DBForeignKeyConstraint> getForeignKeyConstraints() {
        return this.foreignKeyConstraints;
    }

    public void addForeignKeyConstraint(DBForeignKeyConstraint constraint) {
        this.foreignKeyConstraints.add(constraint);
    }

    public void removeForeignKeyConstraint(DBForeignKeyConstraint constraint) {
        this.foreignKeyConstraints.remove(constraint);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBTable that = (DBTable)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int countProviders() {
        return this.foreignKeyConstraints.size();
    }

    @Override
    public DBTable getProvider(int index) {
        return this.foreignKeyConstraints.get(index).getForeignTable();
    }

    @Override
    public boolean requiresProvider(int index) {
        return !this.foreignKeyConstraints.get(index).getForeignKeyColumns().get(0).getForeignKeyColumn().isNullable();
    }

    public String[] getPKColumnNames() {
        DBPrimaryKeyConstraint pkConstraint = this.getPrimaryKeyConstraint();
        Object[] columns = pkConstraint.getColumns();
        String[] pkColumnNames = (String[])ArrayPropertyExtractor.convert((Object[])columns, (String)"name", String.class);
        return pkColumnNames;
    }

    public long getRowCount(Connection connection) {
        Object result = DBUtil.queryScalar((String)("select count(*) from " + this.name), (Connection)connection);
        return ((Number)result).longValue();
    }
}

