/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model;

import java.util.List;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.platform.db.model.DBCatalog;
import org.databene.platform.db.model.DBSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private String name;
    private OrderedNameMap<DBCatalog> catalogs;
    private OrderedNameMap<DBSchema> schemas;

    public Database() {
        this(null, null);
    }

    public Database(String name, OrderedNameMap<DBCatalog> catalogs) {
        this.name = name;
        this.catalogs = OrderedNameMap.createCaseInsensitiveMap();
        if (catalogs != null) {
            this.catalogs.putAll(catalogs);
        }
        this.schemas = OrderedNameMap.createCaseInsensitiveMap();
    }

    public String getName() {
        return this.name;
    }

    public List<DBCatalog> getCatalogs() {
        return this.catalogs.values();
    }

    public DBCatalog getCatalog(String catalogName) {
        return (DBCatalog)this.catalogs.get(catalogName);
    }

    public void addCatalog(DBCatalog catalog) {
        catalog.setDatabase(this);
        this.catalogs.put(catalog.getName(), (Object)catalog);
    }

    public void removeCatalog(DBCatalog catalog) {
        this.catalogs.remove(catalog.getName());
        catalog.setDatabase(null);
    }

    public List<DBSchema> getSchemas() {
        return this.schemas.values();
    }

    public DBSchema getSchema(String schemaName) {
        return (DBSchema)this.schemas.get(schemaName);
    }

    public void addSchema(DBSchema schema) {
        schema.setDatabase(this);
        this.schemas.put(schema.getName(), (Object)schema);
    }

    public void removeSchema(DBSchema schema) {
        this.schemas.remove(schema.getName());
        schema.setDatabase(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Database that = (Database)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

