/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.db.model.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.ErrorHandler;
import org.databene.commons.Escalator;
import org.databene.commons.ImportFailedException;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.StringUtil;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.commons.db.DBUtil;
import org.databene.platform.db.model.DBCatalog;
import org.databene.platform.db.model.DBColumn;
import org.databene.platform.db.model.DBColumnType;
import org.databene.platform.db.model.DBForeignKeyColumn;
import org.databene.platform.db.model.DBForeignKeyConstraint;
import org.databene.platform.db.model.DBImporter;
import org.databene.platform.db.model.DBIndex;
import org.databene.platform.db.model.DBNonUniqueIndex;
import org.databene.platform.db.model.DBPrimaryKeyConstraint;
import org.databene.platform.db.model.DBSchema;
import org.databene.platform.db.model.DBTable;
import org.databene.platform.db.model.DBUniqueConstraint;
import org.databene.platform.db.model.DBUniqueIndex;
import org.databene.platform.db.model.Database;
import org.databene.platform.db.model.jdbc.DBIndexInfo;
import org.databene.platform.db.model.jdbc.ImportedKey;

public final class JDBCDBImporter
implements DBImporter {
    private static final Log logger = LogFactory.getLog(JDBCDBImporter.class);
    private final Connection connection;
    private final String user;
    private String catalogName;
    private String schemaName;
    private boolean importingIndexes;
    private String productName;
    private Escalator escalator = new LoggerEscalator();
    private ErrorHandler errorHandler;

    public JDBCDBImporter(String url, String driverClassname, String user, String password) throws ConnectFailedException {
        this(url, driverClassname, user, password, null, true);
    }

    public JDBCDBImporter(String url, String driver, String user, String password, String schemaName, boolean importingIndexes) throws ConnectFailedException {
        this(DBUtil.connect((String)url, (String)driver, (String)user, (String)password), user, schemaName, importingIndexes);
    }

    public JDBCDBImporter(Connection connection, String user, String schemaName, boolean importingIndexes) {
        this.connection = connection;
        this.user = user;
        this.schemaName = schemaName;
        this.importingIndexes = importingIndexes;
        this.errorHandler = new ErrorHandler(this.getClass());
    }

    public Database importDatabase() throws ImportFailedException {
        logger.info((Object)"Importing database metadata. Be patient, this may take some time...");
        long startTime = System.currentTimeMillis();
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            this.productName = metaData.getDatabaseProductName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Product name: " + this.productName));
            }
            Database database = new Database();
            this.importCatalogs(database, metaData);
            this.importSchemas(database, metaData);
            this.importTables(database, metaData);
            this.importColumns(database, metaData);
            this.importPrimaryKeys(database, metaData);
            if (this.importingIndexes) {
                this.importIndexes(database, metaData);
            }
            this.importImportedKeys(database, metaData);
            Database database2 = database;
            return database2;
        }
        catch (SQLException e) {
            throw new ImportFailedException((Throwable)e);
        }
        finally {
            DBUtil.close((Connection)this.connection);
            long duration = System.currentTimeMillis() - startTime;
            logger.info((Object)("Imported database metadata within " + duration + " ms."));
        }
    }

    private void importCatalogs(Database database, DatabaseMetaData metaData) throws SQLException {
        logger.info((Object)"Importing catalogs");
        ResultSet catalogSet = metaData.getCatalogs();
        int catalogCount = 0;
        while (catalogSet.next()) {
            String catalogName = catalogSet.getString(1);
            logger.debug((Object)("found catalog " + catalogName));
            if (this.schemaName == null && this.user.equalsIgnoreCase(catalogName) || this.schemaName != null && this.schemaName.equalsIgnoreCase(catalogName)) {
                this.catalogName = catalogName;
            }
            database.addCatalog(new DBCatalog(catalogName));
            ++catalogCount;
        }
        if (catalogCount == 0) {
            database.addCatalog(new DBCatalog(null));
        }
        catalogSet.close();
    }

    private void importSchemas(Database database, DatabaseMetaData metaData) throws SQLException {
        logger.info((Object)"Importing schemas");
        ResultSet schemaSet = metaData.getSchemas();
        while (schemaSet.next()) {
            String schemaName = schemaSet.getString(1);
            logger.debug((Object)("found schema " + schemaName));
            if (!schemaName.equalsIgnoreCase(this.schemaName) && (this.schemaName != null || !this.user.equalsIgnoreCase(schemaName))) continue;
            this.schemaName = schemaName;
            DBSchema schema = new DBSchema(schemaName);
            database.addSchema(schema);
        }
        schemaSet.close();
    }

    private void importTables(Database database, DatabaseMetaData metaData) throws SQLException {
        logger.info((Object)"Importing tables");
        ResultSet tableSet = metaData.getTables(this.catalogName, this.schemaName, null, null);
        while (tableSet.next()) {
            DBCatalog catalog;
            String tCatalogName = tableSet.getString(1);
            String tSchemaName = tableSet.getString(2);
            String tableName = tableSet.getString(3);
            if (tableName.startsWith("BIN$")) {
                if (!this.isOracle() || !tableName.startsWith("BIN$")) continue;
                this.escalator.escalate("BIN$ table found (for improved performance execute 'PURGE RECYCLEBIN;')", (Object)this, (Object)tableName);
                continue;
            }
            if (this.ignoreTable(tableName)) continue;
            String tableType = tableSet.getString(4);
            String tableRemarks = tableSet.getString(5);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found table: " + tCatalogName + ", " + tSchemaName + ", " + tableName + ", " + tableType + ", " + tableRemarks));
            }
            DBTable table = new DBTable(tableName);
            table.setDoc(tableRemarks);
            DBSchema schema = database.getSchema(tSchemaName);
            table.setSchema(schema);
            if (schema != null) {
                schema.addTable(table);
            }
            if ((catalog = database.getCatalog(tCatalogName)) == null) continue;
            catalog.addTable(table);
        }
        tableSet.close();
    }

    private boolean isOracle() {
        return this.productName.toLowerCase().startsWith("oracle");
    }

    private void importColumns(Database database, DatabaseMetaData metaData) {
        for (DBCatalog catalog : database.getCatalogs()) {
            try {
                this.importColumns(database, catalog, metaData);
            }
            catch (SQLException e) {
                this.errorHandler.handleError("Error in parsing colmns of catalog " + catalog.getName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importColumns(Database database, DBCatalog catalog, DatabaseMetaData metaData) throws SQLException {
        ResultSet columnSet;
        String catalogName;
        block12: {
            catalogName = catalog.getName();
            String schemaPattern = database.getSchemas().size() == 1 ? database.getSchemas().get(0).getName() : this.schemaName;
            logger.info((Object)("Importing columns for catalog '" + catalogName + "' and schemaPattern '" + this.schemaName + "'"));
            if (this.isOracle()) {
                DBUtil.executeUpdate((String)"ALTER SESSION SET NLS_LENGTH_SEMANTICS=CHAR", (Connection)this.connection);
            }
            columnSet = null;
            columnSet = metaData.getColumns(catalogName, schemaPattern, null, null);
            ResultSetMetaData setMetaData = columnSet.getMetaData();
            if (setMetaData.getColumnCount() != 0) break block12;
            DBUtil.close((ResultSet)columnSet);
            return;
        }
        try {
            while (columnSet.next()) {
                DBSchema schema;
                DBTable table;
                String schemaName = columnSet.getString(2);
                String tableName = columnSet.getString(3);
                if (tableName.startsWith("BIN$")) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("ignoring column: " + catalogName + ", " + schemaName + ", " + tableName));
                    continue;
                }
                if (this.ignoreTable(tableName)) continue;
                String columnName = columnSet.getString(4);
                int sqlType = columnSet.getInt(5);
                String columnType = columnSet.getString(6);
                int columnSize = columnSet.getInt(7);
                int decimalDigits = columnSet.getInt(9);
                boolean nullable = columnSet.getBoolean(11);
                String comment = columnSet.getString(12);
                String defaultValue = columnSet.getString(13);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("found column: " + catalogName + ", " + schemaName + ", " + tableName + ", " + columnName + ", " + sqlType + ", " + columnType + ", " + columnSize + ", " + decimalDigits + ", " + nullable + ", " + comment + ", " + defaultValue));
                }
                Integer fractionDigits = decimalDigits > 0 ? Integer.valueOf(decimalDigits) : null;
                DBColumn column = new DBColumn(columnName, DBColumnType.getInstance(sqlType, columnType), columnSize, fractionDigits);
                if (!StringUtil.isEmpty((String)comment)) {
                    column.setDoc(comment);
                }
                if (!StringUtil.isEmpty((String)defaultValue)) {
                    if (!column.getType().isAlpha()) {
                        defaultValue = JDBCDBImporter.removeBrackets(defaultValue);
                    }
                    column.setDefaultValue(defaultValue.trim());
                }
                if (!nullable) {
                    column.setNullable(false);
                }
                if ((table = catalog.getTable(tableName)) == null && (schema = database.getSchema(schemaName)) != null) {
                    table = schema.getTable(tableName);
                }
                if (table == null) continue;
                table.addColumn(column);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(columnSet);
            throw throwable;
        }
        DBUtil.close((ResultSet)columnSet);
    }

    private void importPrimaryKeys(Database database, DatabaseMetaData metaData) {
        int count = 0;
        DBSchema schema = database.getSchema(this.schemaName);
        if (schema != null) {
            for (DBTable table : schema.getTables()) {
                if (this.ignoreTable(table.getName())) continue;
                this.importPrimaryKeys(metaData, table);
                ++count;
            }
        }
        if (count > 0) {
            return;
        }
        DBCatalog catalog = database.getCatalog(this.catalogName);
        if (catalog != null) {
            for (DBTable table : catalog.getTables()) {
                if (this.ignoreTable(table.getName())) continue;
                this.importPrimaryKeys(metaData, table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPrimaryKeys(DatabaseMetaData metaData, DBTable table) {
        logger.debug((Object)("Importing primary keys for table " + table));
        ResultSet pkset = null;
        try {
            pkset = metaData.getPrimaryKeys(this.catalogName, this.schemaName, table.getName());
            TreeMap<Short, DBColumn> pkComponents = new TreeMap<Short, DBColumn>();
            String pkName = null;
            while (pkset.next()) {
                String tableName = pkset.getString(3);
                if (!tableName.equals(table.getName())) continue;
                String columnName = pkset.getString(4);
                DBColumn column = table.getColumn(columnName);
                short keySeq = pkset.getShort(5);
                pkComponents.put(keySeq, column);
                pkName = pkset.getString(6);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("found pk column " + column + ", " + keySeq + ", " + pkName));
            }
            DBColumn[] columnArray = new DBColumn[pkComponents.size()];
            columnArray = pkComponents.values().toArray(columnArray);
            DBPrimaryKeyConstraint constraint = new DBPrimaryKeyConstraint(pkName, columnArray);
            table.setPrimaryKeyConstraint(constraint);
            for (DBColumn column : columnArray) {
                column.addUkConstraint(constraint);
            }
        }
        catch (SQLException e) {
            try {
                this.errorHandler.handleError("Error importing primary key of table " + table.getName());
            }
            catch (Throwable throwable) {
                DBUtil.close(pkset);
                throw throwable;
            }
            DBUtil.close((ResultSet)pkset);
        }
        DBUtil.close((ResultSet)pkset);
    }

    private void importIndexes(Database database, DatabaseMetaData metaData) {
        for (DBCatalog catalog : database.getCatalogs()) {
            try {
                this.importIndexes(database, catalog, metaData);
            }
            catch (SQLException e) {
                this.errorHandler.handleError("Error parsing metadata of catalog " + catalog.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importIndexes(Database database, DBCatalog catalog, DatabaseMetaData metaData) throws SQLException {
        for (DBTable table : catalog.getTables()) {
            if (this.ignoreTable(table.getName())) continue;
            logger.debug((Object)("Importing indexes for table '" + table.getName() + "'"));
            OrderedNameMap tableIndexes = new OrderedNameMap();
            ResultSet indexSet = null;
            try {
                indexSet = metaData.getIndexInfo(catalog.getName(), null, table.getName(), false, false);
                while (indexSet.next()) {
                    String indexName = null;
                    try {
                        DBIndexInfo index;
                        boolean unique = !indexSet.getBoolean(4);
                        String indexCatalogName = indexSet.getString(5);
                        indexName = indexSet.getString(6);
                        short indexType = indexSet.getShort(7);
                        short ordinalPosition = indexSet.getShort(8);
                        if (ordinalPosition == 0) continue;
                        String columnName = indexSet.getString(9);
                        String ascOrDesc = indexSet.getString(10);
                        Boolean ascending = ascOrDesc != null ? Boolean.valueOf(ascOrDesc.charAt(0) == 'A') : null;
                        int cardinality = indexSet.getInt(11);
                        int pages = indexSet.getInt(12);
                        String filterCondition = indexSet.getString(13);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("found " + (unique ? "unique index " : "index ") + indexName + ", " + indexCatalogName + ", " + indexType + ", " + ordinalPosition + ", " + columnName + ", " + ascOrDesc + ", " + cardinality + ", " + pages + ", " + filterCondition));
                        }
                        if ((index = (DBIndexInfo)tableIndexes.get(indexName)) == null) {
                            index = new DBIndexInfo(indexName, indexType, indexCatalogName, unique, ordinalPosition, columnName, ascending, cardinality, pages, filterCondition);
                            tableIndexes.put(indexName, (Object)index);
                            continue;
                        }
                        index.addColumn(ordinalPosition, columnName);
                    }
                    catch (Exception e) {
                        this.errorHandler.handleError("Error parsing indexes: ", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(indexSet);
                throw throwable;
            }
            DBUtil.close((ResultSet)indexSet);
            for (DBIndexInfo indexInfo : tableIndexes.values()) {
                try {
                    DBCatalog ct;
                    DBIndex index;
                    DBColumn[] columns = table.getColumns(indexInfo.columnNames);
                    if (indexInfo.unique) {
                        DBUniqueConstraint constraint = new DBUniqueConstraint(indexInfo.name, columns);
                        table.addUniqueConstraint(constraint);
                        index = new DBUniqueIndex(indexInfo.name, constraint);
                    } else {
                        index = new DBNonUniqueIndex(indexInfo.name, columns);
                    }
                    if (!StringUtil.isEmpty((String)indexInfo.catalogName) && (ct = database.getCatalog(indexInfo.catalogName)) != null) {
                        ct.addIndex(index);
                    }
                    table.addIndex(index);
                }
                catch (ObjectNotFoundException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private void importImportedKeys(Database database, DatabaseMetaData metaData) {
        logger.info((Object)"Importing imported keys");
        int count = 0;
        for (DBCatalog catalog : database.getCatalogs()) {
            for (DBTable table : catalog.getTables()) {
                if (this.ignoreTable(table.getName())) continue;
                this.importImportedKeys(catalog, null, table, metaData);
                ++count;
            }
        }
        if (count > 0) {
            return;
        }
        for (DBSchema schema : database.getSchemas()) {
            for (DBTable table : schema.getTables()) {
                if (this.ignoreTable(table.getName())) continue;
                this.importImportedKeys(null, schema, table, metaData);
                ++count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importImportedKeys(DBCatalog catalog, DBSchema schema, DBTable table, DatabaseMetaData metaData) {
        logger.debug((Object)("Importing imported keys for table " + table.getName()));
        String catalogName = catalog != null ? catalog.getName() : null;
        String tableName = table.getName();
        String schemaName = schema != null ? schema.getName() : null;
        ResultSet resultSet = null;
        try {
            resultSet = metaData.getImportedKeys(catalogName, schemaName, tableName);
            ArrayList<ImportedKey> importedKeys = new ArrayList<ImportedKey>();
            ImportedKey recent = null;
            while (resultSet.next()) {
                ImportedKey cursor = ImportedKey.parse(resultSet, catalog, schema, table);
                if (cursor == null) continue;
                if (cursor.key_seq > 1) {
                    DBColumn foreignKeyColumn = table.getColumn(cursor.fkcolumn_name);
                    DBColumn targetColumn = table.getColumn(cursor.pkcolumn_name);
                    assert (recent != null);
                    recent.addForeignKeyColumn(foreignKeyColumn, targetColumn);
                } else {
                    importedKeys.add(cursor);
                }
                recent = cursor;
            }
            for (ImportedKey key : importedKeys) {
                DBForeignKeyConstraint foreignKeyConstraint = new DBForeignKeyConstraint(key.fk_name, new DBForeignKeyColumn[0]);
                for (DBForeignKeyColumn foreignKeyColumn : key.getForeignKeyColumns()) {
                    foreignKeyConstraint.addForeignKeyColumn(foreignKeyColumn);
                }
                table.addForeignKeyConstraint(foreignKeyConstraint);
            }
        }
        catch (SQLException e) {
            try {
                this.errorHandler.handleError("Error importing foreign key constraints", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
            DBUtil.close((ResultSet)resultSet);
        }
        DBUtil.close((ResultSet)resultSet);
    }

    private boolean ignoreTable(String tableName) {
        return tableName.contains("$");
    }

    private static String removeBrackets(String defaultValue) {
        if (StringUtil.isEmpty((String)defaultValue)) {
            return defaultValue;
        }
        if (!defaultValue.startsWith("(") || !defaultValue.endsWith(")")) {
            return defaultValue;
        }
        return JDBCDBImporter.removeBrackets(defaultValue.substring(1, defaultValue.length() - 1));
    }

    public String getProductName() {
        return this.productName;
    }

    public void setFaultTolerant(boolean faultTolerant) {
        this.errorHandler = new ErrorHandler(this.getClass().getName(), faultTolerant ? ErrorHandler.Level.warn : ErrorHandler.Level.fatal);
    }
}

