/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.dbunit;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.ToStringConverter;
import org.databene.model.consumer.AbstractConsumer;
import org.databene.model.data.Entity;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitEntityExporter
extends AbstractConsumer<Entity> {
    private static final Log logger = LogFactory.getLog(DbUnitEntityExporter.class);
    private static final String DEFAULT_FILE_ENCODING = "UTF-8";
    private static final String DEFAULT_URI = "data.dbunit.xml";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    private ToStringConverter toStringConverter;
    private String uri;
    private String encoding;
    private OutputStream out;
    private TransformerHandler handler;

    public DbUnitEntityExporter() {
        this(DEFAULT_URI);
    }

    public DbUnitEntityExporter(String uri) {
        this(uri, DEFAULT_FILE_ENCODING);
    }

    public DbUnitEntityExporter(String uri, String encoding) {
        this.setUri(uri);
        this.setEncoding(encoding);
        this.toStringConverter = new ToStringConverter(null, DATE_PATTERN, TIMESTAMP_PATTERN);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        String string = this.encoding = encoding != null ? encoding : SystemInfo.getFileEncoding();
        if (this.encoding == null) {
            this.encoding = DEFAULT_FILE_ENCODING;
        }
    }

    @Override
    public void startConsuming(Entity entity) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("exporting " + entity));
            }
            if (this.out == null) {
                this.initPrinter();
            }
            AttributesImpl atts = new AttributesImpl();
            for (Map.Entry<String, Object> entry : entity.getComponents().entrySet()) {
                String s;
                Object value = entry.getValue();
                if (value == null || (s = this.toStringConverter.convert(value)) == null) continue;
                atts.addAttribute("", "", entry.getKey(), "CDATA", s);
            }
            this.handler.startElement("", "", entity.getName(), atts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new ConfigurationError("Error in processing element: " + entity, (Throwable)e);
        }
    }

    @Override
    public void finishConsuming(Entity entity) {
        try {
            this.handler.endElement("", "", entity.getName());
        }
        catch (SAXException e) {
            throw new ConfigurationError("Error in processing element: " + entity, (Throwable)e);
        }
    }

    @Override
    public void flush() {
        IOUtil.flush((OutputStream)this.out);
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.handler.endElement("", "", "dataset");
                this.handler.endDocument();
                this.handler = null;
            }
            catch (SAXException e) {
                throw new ConfigurationError("Error closing XML file.", (Throwable)e);
            }
            finally {
                IOUtil.close((OutputStream)this.out);
            }
        }
    }

    private void initPrinter() throws IOException {
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.handler = tf.newTransformerHandler();
            Transformer serializer = this.handler.getTransformer();
            serializer.setOutputProperty("encoding", this.encoding);
            serializer.setOutputProperty("indent", "yes");
            this.out = new FileOutputStream(this.uri);
            this.handler.setResult(new StreamResult(this.out));
            this.handler.startDocument();
            this.handler.startElement("", "", "dataset", null);
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationError((Throwable)e);
        }
        catch (SAXException e) {
            throw new ConfigurationError("Error in initializing XML file", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.uri + ", " + this.encoding + "]";
    }
}

