/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.dbunit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.Context;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.xml.XMLUtil;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.DataModel;
import org.databene.model.data.Entity;
import org.databene.script.ScriptUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitEntityIterator
implements HeavyweightIterator<Entity> {
    private static final Log logger = LogFactory.getLog(DbUnitEntityIterator.class);
    private Context context;
    private List<Row> rows;
    private int nextRowNum;
    private DataModel dataModel = DataModel.getDefaultInstance();

    public DbUnitEntityIterator(String uri, Context context) throws IOException {
        this.context = context;
        this.rows = new ArrayList<Row>();
        Document document = this.readDocument(uri);
        if (this.isFlatDataset(document)) {
            this.parseFlatDataset(document);
        } else {
            this.parseDataset(document);
        }
        this.processScripts();
        this.nextRowNum = 0;
    }

    public boolean hasNext() {
        return this.nextRowNum < this.rows.size();
    }

    public Entity next() {
        if (this.nextRowNum < this.rows.size()) {
            Row row = this.rows.get(this.nextRowNum);
            String[] rowValues = row.getValues();
            ComplexTypeDescriptor descriptor = this.getType(row);
            Entity result = new Entity(descriptor, new Object[0]);
            for (int i = 0; i < rowValues.length; ++i) {
                String rowValue = rowValues[i];
                result.setComponent(row.getColumnName(i), rowValue);
            }
            ++this.nextRowNum;
            return result;
        }
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    private ComplexTypeDescriptor getType(Row row) {
        String name = row.getTableName();
        ComplexTypeDescriptor type = (ComplexTypeDescriptor)this.dataModel.getTypeDescriptor(name);
        if (type == null) {
            type = new ComplexTypeDescriptor(name);
        }
        return type;
    }

    private void processScripts() {
        for (Row row : this.rows) {
            String[] cells = row.getValues();
            for (int i = 0; i < cells.length; ++i) {
                cells[i] = String.valueOf(ScriptUtil.render((String)cells[i], (Context)this.context));
            }
        }
    }

    private boolean isFlatDataset(Document document) {
        return document.getDocumentElement().getElementsByTagName("table").getLength() == 0;
    }

    private Document readDocument(String uri) throws IOException {
        return XMLUtil.parse((String)uri, (boolean)false);
    }

    private void parseDataset(Document document) {
        Element documentElement = document.getDocumentElement();
        NodeList tableNodes = documentElement.getElementsByTagName("table");
        for (int tablenum = 0; tablenum < tableNodes.getLength(); ++tablenum) {
            Element tableNode = (Element)tableNodes.item(tablenum);
            String tableName = tableNode.getAttribute("name");
            NodeList columns = tableNode.getElementsByTagName("column");
            String[] columnNames = new String[columns.getLength()];
            for (int colnum = 0; colnum < columns.getLength(); ++colnum) {
                Element column = (Element)columns.item(colnum);
                columnNames[colnum] = column.getTextContent();
            }
            Table table = new Table(tableName, columnNames);
            NodeList rows = tableNode.getElementsByTagName("row");
            for (int rownum = 0; rownum < rows.getLength(); ++rownum) {
                Element row = (Element)rows.item(rownum);
                NodeList cellNodes = row.getElementsByTagName("value");
                String[] values = new String[cellNodes.getLength()];
                for (int cellnum = 0; cellnum < cellNodes.getLength(); ++cellnum) {
                    Element cell = (Element)cellNodes.item(cellnum);
                    values[cellnum] = cell.getTextContent();
                }
                this.rows.add(new Row(tableName, table.getColumnNames(), values));
            }
        }
    }

    private void parseFlatDataset(Document document) {
        Element documentElement = document.getDocumentElement();
        NodeList rowNodes = documentElement.getChildNodes();
        for (int rownum = 0; rownum < rowNodes.getLength(); ++rownum) {
            Node node = rowNodes.item(rownum);
            if (!(node instanceof Element)) continue;
            Element tableNode = (Element)node;
            String tableName = tableNode.getNodeName();
            NamedNodeMap attributes = tableNode.getAttributes();
            String[] columnNames = new String[attributes.getLength()];
            String[] values = new String[attributes.getLength()];
            for (int childnum = 0; childnum < attributes.getLength(); ++childnum) {
                Attr attNode = (Attr)attributes.item(childnum);
                columnNames[childnum] = attNode.getNodeName();
                values[childnum] = attNode.getValue();
            }
            Row row = new Row(tableName, columnNames, values);
            logger.debug((Object)("parsed row " + row));
            this.rows.add(row);
        }
    }

    private static class Row {
        private String tableName;
        private String[] columnNames;
        private String[] values;

        public Row(String tableName, String[] columnNames, String[] values) {
            this.tableName = tableName;
            this.columnNames = columnNames;
            this.values = values;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String[] getValues() {
            return this.values;
        }

        public String getColumnName(int i) {
            return this.columnNames[i];
        }

        public String toString() {
            return this.tableName + '[' + ArrayFormat.format((Object[])this.values) + ']';
        }
    }

    private static class Table {
        private String name;
        private String[] columnNames;

        public Table(String name, String[] columns) {
            this.name = name;
            this.columnNames = columns;
        }

        public String getName() {
            return this.name;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumn(int i) {
            return this.columnNames[i];
        }

        public String toString() {
            return this.name + '[' + ArrayFormat.format((Object[])this.columnNames) + ']';
        }

        public int getColumnIndex(String columnName) {
            return ArrayUtil.indexOf((Object)columnName, (Object[])this.columnNames);
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }
    }
}

