/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.flat;

import java.io.Writer;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.Accessor;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.Escalator;
import org.databene.commons.IOUtil;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.ParseUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.AccessingConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.FormatFormatConverter;
import org.databene.commons.format.Alignment;
import org.databene.commons.format.PadFormat;
import org.databene.document.flat.FlatFileColumnDescriptor;
import org.databene.model.consumer.TextFileExporter;
import org.databene.model.data.ComponentAccessor;
import org.databene.model.data.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatFileEntityExporter
extends TextFileExporter<Entity> {
    private static final Log logger = LogFactory.getLog(FlatFileEntityExporter.class);
    private static final Escalator escalator = new LoggerEscalator();
    private Converter<Entity, String>[] converters;

    public FlatFileEntityExporter() {
        this(null, null);
    }

    public FlatFileEntityExporter(String uri, String columnFormatList) {
        this(uri, null, columnFormatList);
    }

    public FlatFileEntityExporter(String uri, String encoding, String columnFormatList) {
        super(uri, encoding, null);
        this.uri = uri;
        this.setColumns(columnFormatList);
    }

    @Deprecated
    public void setProperties(String properties) {
        escalator.escalate("Property 'properties' of " + this.getClass().getName() + " has been deprecated. " + "Use property 'columns' instead.", (Object)this, (Object)properties);
        this.setColumns(properties);
    }

    public void setColumns(String columnFormatList) {
        if (columnFormatList == null) {
            this.converters = null;
            return;
        }
        try {
            String[] columnFormats = StringUtil.tokenize((String)columnFormatList, (char)',');
            this.converters = new Converter[columnFormats.length];
            for (int i = 0; i < columnFormats.length; ++i) {
                String columnFormat = columnFormats[i];
                int lbIndex = columnFormat.indexOf(91);
                if (lbIndex < 0) {
                    throw new ConfigurationError("'[' expected in column format descriptor '" + columnFormat + "'");
                }
                int rbIndex = columnFormat.indexOf(93);
                if (rbIndex < 0) {
                    throw new ConfigurationError("']' expected in column format descriptor '" + columnFormat + "'");
                }
                String columnName = columnFormat.substring(0, lbIndex);
                ParsePosition pos = new ParsePosition(lbIndex + 1);
                int width = (int)ParseUtil.parseNonNegativeInteger((String)columnFormat, (ParsePosition)pos);
                int minFractionDigits = 0;
                int maxFractionDigits = 2;
                if (pos.getIndex() < rbIndex && columnFormat.charAt(pos.getIndex()) == '.') {
                    pos.setIndex(pos.getIndex() + 1);
                    maxFractionDigits = minFractionDigits = (int)ParseUtil.parseNonNegativeInteger((String)columnFormat, (ParsePosition)pos);
                }
                Alignment alignment = Alignment.LEFT;
                if (pos.getIndex() < rbIndex) {
                    char alignmentCode = columnFormat.charAt(pos.getIndex());
                    switch (alignmentCode) {
                        case 'l': {
                            alignment = Alignment.LEFT;
                            break;
                        }
                        case 'r': {
                            alignment = Alignment.RIGHT;
                            break;
                        }
                        case 'c': {
                            alignment = Alignment.CENTER;
                            break;
                        }
                        default: {
                            throw new ConfigurationError("Illegal alignment code '" + alignmentCode + "'" + " in colun format descriptor '" + columnFormat + "'");
                        }
                    }
                    pos.setIndex(pos.getIndex() + 1);
                }
                char padChar = ' ';
                if (pos.getIndex() < rbIndex) {
                    padChar = columnFormat.charAt(pos.getIndex());
                    pos.setIndex(pos.getIndex() + 1);
                }
                assert (pos.getIndex() == rbIndex);
                FlatFileColumnDescriptor descriptor = new FlatFileColumnDescriptor(columnName, width, alignment, padChar);
                this.converters[i] = new ConverterChain(new Converter[]{new AccessingConverter(Entity.class, Object.class, (Accessor)new ComponentAccessor(descriptor.getName())), this.plainConverter, new FormatFormatConverter(String.class, (Format)new PadFormat(descriptor.getWidth(), minFractionDigits, maxFractionDigits, descriptor.getAlignment(), padChar))});
            }
        }
        catch (ParseException e) {
            throw new ConfigurationError("Invalid column definition: " + columnFormatList, (Throwable)e);
        }
    }

    @Override
    public void flush() {
        if (this.printer != null) {
            this.printer.flush();
        }
    }

    @Override
    public void close() {
        IOUtil.close((Writer)this.printer);
    }

    @Override
    protected void postInitPrinter() {
        if (this.converters == null) {
            throw new ConfigurationError("Property 'columns' not set on bean " + this.getClass().getName());
        }
    }

    @Override
    protected void startConsumingImpl(Entity entity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("exporting " + entity));
        }
        for (Converter<Entity, String> converter : this.converters) {
            this.printer.print((String)converter.convert((Object)entity));
        }
        this.printer.println();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + ArrayFormat.format((Object[])new Object[0]) + ']';
    }
}

