/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.flat;

import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.SystemInfo;
import org.databene.commons.bean.ArrayPropertyExtractor;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.ConvertingIterable;
import org.databene.commons.converter.NoOpConverter;
import org.databene.commons.format.PadFormat;
import org.databene.document.flat.FlatFileColumnDescriptor;
import org.databene.document.flat.FlatFileLineIterable;
import org.databene.document.flat.FlatFileUtil;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.Entity;
import org.databene.model.data.EntitySource;
import org.databene.platform.array.Array2EntityConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatFileEntitySource
extends ConvertingIterable<String[], Entity>
implements EntitySource {
    private String uri;
    private String encoding;
    private ComplexTypeDescriptor entityDescriptor;
    private FlatFileColumnDescriptor[] descriptors;
    private boolean initialized;
    private Converter<String, String> preprocessor;

    public FlatFileEntitySource() {
        this(null, null, SystemInfo.getFileEncoding(), new FlatFileColumnDescriptor[0]);
    }

    public FlatFileEntitySource(String uri, ComplexTypeDescriptor entityDescriptor, String encoding, FlatFileColumnDescriptor ... descriptors) {
        this(uri, entityDescriptor, (Converter<String, String>)new NoOpConverter(), encoding, descriptors);
    }

    public FlatFileEntitySource(String uri, ComplexTypeDescriptor entityDescriptor, Converter<String, String> preprocessor, String encoding, FlatFileColumnDescriptor ... descriptors) {
        super(null, null);
        this.uri = uri;
        this.encoding = encoding;
        this.entityDescriptor = entityDescriptor;
        this.descriptors = descriptors;
        this.preprocessor = preprocessor;
        this.initialized = false;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEntity() {
        return this.entityDescriptor.getName();
    }

    public void setEntity(String entity) {
        this.entityDescriptor = new ComplexTypeDescriptor(entity);
    }

    public void setProperties(String properties) {
        this.descriptors = FlatFileUtil.parseProperties((String)properties);
    }

    public Class<Entity> getType() {
        if (!this.initialized) {
            this.init();
        }
        return Entity.class;
    }

    public HeavyweightIterator<Entity> iterator() {
        if (!this.initialized) {
            this.init();
        }
        return super.iterator();
    }

    private void init() {
        this.iterable = FlatFileEntitySource.createIterable(this.uri, this.descriptors, this.encoding);
        this.converter = this.createConverter(this.entityDescriptor, this.descriptors);
    }

    private Converter<String[], Entity> createConverter(ComplexTypeDescriptor entityDescriptor, FlatFileColumnDescriptor[] descriptors) {
        String[] featureNames = (String[])ArrayPropertyExtractor.convert((Object[])descriptors, (String)"name", String.class);
        Array2EntityConverter a2eConverter = new Array2EntityConverter(entityDescriptor, featureNames);
        ArrayConverter aConv = new ArrayConverter(String.class, String.class, new Converter[]{this.preprocessor});
        ConverterChain converter = new ConverterChain(new Converter[]{aConv, a2eConverter});
        return converter;
    }

    private static Iterable<String[]> createIterable(String uri, FlatFileColumnDescriptor[] descriptors, String encoding) {
        PadFormat[] formats = (PadFormat[])ArrayPropertyExtractor.convert((Object[])descriptors, (String)"format", PadFormat.class);
        return new FlatFileLineIterable(uri, formats, true, encoding);
    }
}

