/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.script;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.model.consumer.TextFileExporter;
import org.databene.model.data.Entity;
import org.databene.script.ScriptedDocumentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptedEntityExporter
extends TextFileExporter<Entity> {
    private static final Log logger = LogFactory.getLog(ScriptedEntityExporter.class);
    private String headerScript;
    private String partScript;
    private String footerScript;
    private ScriptedDocumentWriter<Entity> docWriter;

    public ScriptedEntityExporter() {
        this(null, null);
    }

    public ScriptedEntityExporter(String uri, String partScript) {
        this(uri, null, null, partScript, null);
    }

    public ScriptedEntityExporter(String uri, String encoding, String headerScript, String partScript, String footerScript) {
        super(uri, encoding, null);
        this.headerScript = headerScript;
        this.partScript = partScript;
        this.footerScript = footerScript;
    }

    public String getHeaderScript() {
        return this.headerScript;
    }

    public void setHeaderScript(String headerScript) {
        this.headerScript = headerScript;
    }

    public String getPartScript() {
        return this.partScript;
    }

    public void setPartScript(String partScript) {
        this.partScript = partScript;
    }

    public String getFooterScript() {
        return this.footerScript;
    }

    public void setFooterScript(String footerScript) {
        this.footerScript = footerScript;
    }

    @Override
    protected void postInitPrinter() {
        try {
            this.docWriter = new ScriptedDocumentWriter((Writer)this.printer, this.headerScript, this.partScript, this.footerScript);
            if (this.append) {
                this.docWriter.setWriteHeader(false);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }

    @Override
    protected void startConsumingImpl(Entity entity) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exporting " + entity));
            }
            this.docWriter.writeElement((Object)entity);
        }
        catch (IOException e) {
            throw new ConfigurationError((Throwable)e);
        }
    }
}

