/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.xls;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.StringUtil;
import org.databene.model.consumer.FileExporter;
import org.databene.model.consumer.FormattingConsumer;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.Entity;
import org.databene.platform.csv.CSVEntityExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSEntityExporter
extends FormattingConsumer<Entity>
implements FileExporter<Entity> {
    private static final Log logger = LogFactory.getLog(CSVEntityExporter.class);
    private static final Escalator escalator = new LoggerEscalator();
    private static final String DEFAULT_URI = "export.xls";
    private String uri;
    private String[] columnNames;
    private HSSFWorkbook workbook;
    HSSFSheet sheet;
    private int rowCount;
    private HSSFCellStyle dateCellStyle;

    public XLSEntityExporter() {
        this(DEFAULT_URI);
    }

    public XLSEntityExporter(String uri) {
        this(uri, (String)null);
    }

    public XLSEntityExporter(String uri, String columnSpec) {
        this.uri = uri;
        this.setColumns(columnSpec);
    }

    public XLSEntityExporter(ComplexTypeDescriptor descriptor) {
        this(descriptor.getName() + ".csv", descriptor);
    }

    public XLSEntityExporter(String uri, ComplexTypeDescriptor descriptor) {
        this.uri = uri;
        List<ComponentDescriptor> componentDescriptors = descriptor.getComponents();
        List componentNames = BeanUtil.extractProperties(componentDescriptors, (String)"name");
        this.columnNames = (String[])CollectionUtil.toArray((Collection)componentNames, String.class);
        this.columnNames = new String[0];
        this.workbook = null;
        this.sheet = null;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setColumns(String columnsSpec) {
        if (StringUtil.isEmpty((String)columnsSpec)) {
            this.columnNames = null;
        } else {
            this.columnNames = StringUtil.tokenize((String)columnsSpec, (char)',');
            StringUtil.trimAll((String[])this.columnNames);
        }
    }

    @Deprecated
    public void setProperties(String properties) {
        escalator.escalate("XLSEntityExporter.properties is deprecated. Use XLSEntityExporter.columns instead.", this.getClass(), null);
        this.setColumns(properties);
    }

    @Deprecated
    public void setAttributes(String attributes) {
        escalator.escalate("XLSEntityExporter.attributes is deprecated. Use XLSEntityExporter.columns instead.", this.getClass(), null);
        this.setColumns(attributes);
    }

    @Override
    public void startConsuming(Entity entity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("exporting " + entity));
        }
        if (this.workbook == null) {
            this.initWorkbook(entity);
        }
        HSSFRow row = this.sheet.createRow(this.rowCount++);
        for (int i = 0; i < this.columnNames.length; ++i) {
            Object value = entity.getComponent(this.columnNames[i]);
            this.render(row, i, value);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        try {
            if (this.workbook == null) {
                this.initWorkbook(null);
            }
            this.autoSizeColumns();
            FileOutputStream fileOut = new FileOutputStream(this.uri);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationError((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initWorkbook(Entity entity) {
        this.workbook = new HSSFWorkbook();
        this.sheet = this.workbook.createSheet("new sheet");
        this.rowCount = 0;
        this.dateCellStyle = this.workbook.createCellStyle();
        HSSFDataFormat format = this.workbook.createDataFormat();
        short dateFormat = format.getFormat(this.getDatePattern());
        this.dateCellStyle.setDataFormat(dateFormat);
        this.writeHeaderRow(entity);
    }

    private void writeHeaderRow(Entity entity) {
        HSSFRow row = this.sheet.createRow(this.rowCount++);
        if (ArrayUtil.isEmpty((Object[])this.columnNames) && entity != null) {
            this.columnNames = (String[])CollectionUtil.toArray(entity.getComponents().keySet());
        }
        if (this.columnNames != null) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                row.createCell(i).setCellValue((RichTextString)new HSSFRichTextString(this.columnNames[i]));
            }
        }
    }

    private void render(HSSFRow row, int column, Object value) {
        HSSFCell cell = row.createCell(column);
        if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellStyle(this.dateCellStyle);
            cell.setCellValue((Date)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            String s = this.plainConverter.convert(value);
            cell.setCellValue((RichTextString)new HSSFRichTextString(s));
        }
    }

    private void autoSizeColumns() {
        for (int colnum = 0; colnum <= this.sheet.getLastRowNum(); ++colnum) {
            this.sheet.autoSizeColumn(colnum);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + ArrayFormat.format((Object[])this.columnNames) + ") -> " + this.uri;
    }
}

