/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.xls;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.converter.NoOpConverter;
import org.databene.commons.iterator.ConvertingIterator;
import org.databene.document.xls.XLSLineIterator;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.Entity;
import org.databene.platform.array.Array2EntityConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSEntityIterator
implements HeavyweightIterator<Entity> {
    private String uri;
    private int sheetIndex;
    private ComplexTypeDescriptor entityDescriptor;
    private HeavyweightIterator<Entity> source;

    public XLSEntityIterator(String uri, int sheetIndex, String entityName) throws FileNotFoundException {
        this(uri, sheetIndex, new ComplexTypeDescriptor(entityName), (Converter<String, ? extends Object>)new NoOpConverter());
    }

    public XLSEntityIterator(String uri, int sheetIndex, String entityName, Converter<String, ? extends Object> preprocessor) throws FileNotFoundException {
        this(uri, sheetIndex, new ComplexTypeDescriptor(entityName), preprocessor);
    }

    public XLSEntityIterator(String uri, int sheetIndex, ComplexTypeDescriptor descriptor, Converter<String, ? extends Object> preprocessor) throws FileNotFoundException {
        this.uri = uri;
        this.sheetIndex = sheetIndex;
        this.entityDescriptor = descriptor;
        try {
            XLSLineIterator lineIterator = new XLSLineIterator(uri, sheetIndex, preprocessor);
            String[] featureNames = lineIterator.getHeaders();
            Array2EntityConverter converter = new Array2EntityConverter(this.entityDescriptor, featureNames);
            this.source = new ConvertingIterator((Iterator)lineIterator, (Converter)converter);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Error in processing " + uri, e);
        }
    }

    public void remove() {
        this.source.remove();
    }

    public boolean hasNext() {
        return this.source.hasNext();
    }

    public Entity next() {
        if (!this.source.hasNext()) {
            throw new IllegalStateException("No more entity to fetch, check hasNext() before calling next()");
        }
        return (Entity)this.source.next();
    }

    public void close() {
        this.source.close();
    }

    public static List<Entity> parseAll(String uri, int sheetIndex, ComplexTypeDescriptor descriptor, Converter<String, ? extends Object> preprocessor) throws FileNotFoundException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        XLSEntityIterator iterator = new XLSEntityIterator(uri, sheetIndex, descriptor, preprocessor);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public String getUri() {
        return this.uri;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public String getEntityName() {
        return this.entityDescriptor.getName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[uri=" + this.uri + ", sheetIndex=" + this.sheetIndex + ", " + "entityName=" + this.entityDescriptor.getName() + "]";
    }
}

