/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.xls;

import java.io.FileNotFoundException;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.converter.NoOpConverter;
import org.databene.model.data.AbstractEntitySource;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.Entity;
import org.databene.platform.xls.XLSEntityIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XLSEntitySource
extends AbstractEntitySource {
    private String uri;
    private int sheetIndex;
    private Converter<String, ?> preprocessor;
    private ComplexTypeDescriptor entityDescriptor;

    public XLSEntitySource() {
        this(null, 0, null);
    }

    public XLSEntitySource(String uri, int sheetIndex, String entityName) {
        this(uri, sheetIndex, new ComplexTypeDescriptor(entityName), (Converter<String, ? extends Object>)new NoOpConverter());
    }

    public XLSEntitySource(String uri, int sheetIndex, String entityName, Converter<String, ? extends Object> preprocessor) {
        this(uri, sheetIndex, new ComplexTypeDescriptor(entityName), preprocessor);
    }

    public XLSEntitySource(String uri, int sheetIndex, ComplexTypeDescriptor descriptor, Converter<String, ? extends Object> preprocessor) {
        this.uri = uri;
        this.sheetIndex = sheetIndex;
        this.entityDescriptor = descriptor;
        this.preprocessor = preprocessor;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getEntityName() {
        return this.entityDescriptor.getName();
    }

    public void setEntityName(String entityName) {
        this.entityDescriptor = new ComplexTypeDescriptor(entityName);
    }

    public HeavyweightIterator<Entity> iterator() {
        try {
            return new XLSEntityIterator(this.uri, this.sheetIndex, this.entityDescriptor, this.preprocessor);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationError("Cannot create iterator. ", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[uri=" + this.uri + ", entityName=" + this.entityDescriptor.getName() + "]";
    }
}

