/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.xml;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.ToStringConverter;
import org.databene.model.consumer.AbstractConsumer;
import org.databene.model.consumer.FileExporter;
import org.databene.model.data.Entity;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEntityExporter
extends AbstractConsumer<Entity>
implements FileExporter<Entity> {
    private static final Log logger = LogFactory.getLog(XMLEntityExporter.class);
    private static final String DEFAULT_ENCODING = SystemInfo.getFileEncoding();
    private static final String DEFAULT_URI = "export.xml";
    private static final ToStringConverter converter = new ToStringConverter("", "yyyy-MM-dd", "yyyy-MM-dd'T'hh:mm:ss.SSS");
    private String uri;
    private String encoding;
    private OutputStream out;
    private TransformerHandler handler;

    public XMLEntityExporter() {
        this(DEFAULT_URI);
    }

    public XMLEntityExporter(String uri) {
        this(uri, DEFAULT_ENCODING);
    }

    public XMLEntityExporter(String uri, String encoding) {
        this.uri = uri;
        this.encoding = encoding;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void startConsuming(Entity entity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("startConsuming(" + entity + ')'));
        }
        if (this.out == null) {
            this.initHandler();
        }
        this.renderElementStart(entity);
    }

    @Override
    public void finishConsuming(Entity entity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("finishConsuming(" + entity + ')'));
        }
        try {
            this.handler.endElement("", "", entity.getName());
        }
        catch (SAXException e) {
            throw new ConfigurationError("Error in processing element: " + entity, (Throwable)e);
        }
    }

    @Override
    public void flush() {
        IOUtil.flush((OutputStream)this.out);
    }

    @Override
    public void close() {
        if (this.out != null) {
            try {
                this.handler.endDocument();
                this.handler = null;
            }
            catch (SAXException e) {
                throw new ConfigurationError("Error closing XML file.", (Throwable)e);
            }
            finally {
                IOUtil.close((OutputStream)this.out);
            }
        }
    }

    private void renderSimpleType(Object value) throws SAXException {
        String s = converter.convert(value);
        char[] cc = StringUtil.getChars((String)s);
        this.handler.characters(cc, 0, cc.length);
    }

    private void renderElementStart(Entity entity) {
        try {
            AttributesImpl atts = new AttributesImpl();
            for (Map.Entry<String, Object> entry : entity.getComponents().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null || key == null || "__SIMPLE_CONTENT".equals(key) || !this.hasSimpleType(value)) continue;
                atts.addAttribute("", "", entry.getKey(), "CDATA", converter.convert(value));
            }
            this.handler.startElement("", "", entity.getName(), atts);
            Object content = entity.getComponent("__SIMPLE_CONTENT");
            if (content != null) {
                this.renderSimpleType(content);
            }
        }
        catch (SAXException e) {
            throw new ConfigurationError("Error in processing element: " + entity, (Throwable)e);
        }
    }

    private boolean hasSimpleType(Object value) {
        return !value.getClass().isArray() && !(value instanceof Entity);
    }

    private void initHandler() {
        logger.debug((Object)("Initializing " + this.uri));
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.handler = tf.newTransformerHandler();
            Transformer serializer = this.handler.getTransformer();
            serializer.setOutputProperty("encoding", this.encoding);
            serializer.setOutputProperty("indent", "yes");
            this.out = new FileOutputStream(this.uri);
            this.handler.setResult(new StreamResult(this.out));
            this.handler.startDocument();
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationError((Throwable)e);
        }
        catch (SAXException e) {
            throw new ConfigurationError("Error in initializing XML file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error writing file " + this.uri, e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.uri + ']';
    }
}

