/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.benerator.engine.BeneratorContext;
import org.databene.benerator.parser.ModelParser;
import org.databene.commons.Assert;
import org.databene.commons.BeanUtil;
import org.databene.commons.CollectionUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.StringUtil;
import org.databene.commons.xml.XMLUtil;
import org.databene.model.data.AlternativeGroupDescriptor;
import org.databene.model.data.ComplexTypeDescriptor;
import org.databene.model.data.ComponentDescriptor;
import org.databene.model.data.DataModel;
import org.databene.model.data.DefaultDescriptorProvider;
import org.databene.model.data.FeatureDescriptor;
import org.databene.model.data.InstanceDescriptor;
import org.databene.model.data.Mode;
import org.databene.model.data.PartDescriptor;
import org.databene.model.data.SimpleTypeDescriptor;
import org.databene.model.data.TypeDescriptor;
import org.databene.model.data.UnionSimpleTypeDescriptor;
import org.databene.model.data.UnresolvedTypeDescriptor;
import org.databene.platform.xml.Annotation;
import org.databene.platform.xml.XMLSchemaNativeTypeProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSchemaDescriptorProvider
extends DefaultDescriptorProvider {
    private static final String REF = "ref";
    private static final String KEY = "key";
    private static final String KEYREF = "keyref";
    private static final String UNIQUE = "unique";
    private static final String ALL = "all";
    private static final String COMPLEX_CONTENT = "complexContent";
    private static final String SIMPLE_CONTENT = "simpleContent";
    private static final String ATTRIBUTE = "attribute";
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private ModelParser parser;
    private BeneratorContext context;
    private DataModel dataModel;
    private List<String> propertiesFiles;
    private Map<String, String> namespaces = new HashMap<String, String>();
    public static final String INCLUDE = "include";
    public static final String IMPORT = "import";
    public static final String SIMPLE_TYPE = "simpleType";
    public static final String COMPLEX_TYPE = "complexType";
    public static final String ANNOTATION = "annotation";
    public static final String SEQUENCE = "sequence";
    public static final String CHOICE = "choice";
    public static final String EXTENSION = "extension";
    public static final String UNION = "union";
    public static final String ELEMENT = "element";
    public static final String GROUP = "group";
    public static final String ATTRIBUTE_GROUP = "attributeGroup";
    public static final String NAME = "name";
    public static final String RESTRICTION = "restriction";
    public static final String BASE = "base";
    public static final String VALUE = "value";
    public static final String LENGTH = "length";
    public static final String MAX_INCLUSIVE = "maxInclusive";
    public static final String MIN_INCLUSIVE = "minInclusive";
    public static final String ENUMERATION = "enumeration";
    private static final String TYPE = "type";
    private static Log logger = LogFactory.getLog(XMLSchemaDescriptorProvider.class);

    public XMLSchemaDescriptorProvider(String schemaUri, BeneratorContext context) {
        this(schemaUri, context, DataModel.getDefaultInstance());
    }

    public XMLSchemaDescriptorProvider(String schemaUri, BeneratorContext context, DataModel dataModel) {
        super(schemaUri, true);
        this.parser = new ModelParser(context);
        this.context = context;
        this.dataModel = dataModel;
        this.propertiesFiles = new ArrayList<String>();
        this.setSchemaUri(schemaUri);
    }

    public void setSchemaUri(String schemaUri) {
        try {
            this.dataModel.addDescriptorProvider(new XMLSchemaNativeTypeProvider(SCHEMA_NAMESPACE));
            Document document = XMLUtil.parse((String)schemaUri);
            this.namespaces = XMLUtil.getNamespaces((Document)document);
            this.id = XMLUtil.getTargetNamespace((Document)document);
            this.dataModel.addDescriptorProvider(this);
            this.parseStructure(document);
            this.parseDetails(document);
        }
        catch (IOException e) {
            throw new ConfigurationError("Error parsing schemaUri: " + schemaUri, (Throwable)e);
        }
    }

    public String[] getPropertiesFiles() {
        return (String[])CollectionUtil.toArray(this.propertiesFiles);
    }

    public BeneratorContext getContext() {
        return this.context;
    }

    private void parseStructure(Document document) throws IOException {
        Element[] childElements;
        logger.debug((Object)"parseStructure()");
        Element root = document.getDocumentElement();
        for (Element element : childElements = XMLUtil.getChildElements((Element)root)) {
            String nodeName = XMLUtil.localName((Element)element);
            String nameAttribute = element.getAttribute(NAME);
            Set COMPLEX_ELEMENTS = CollectionUtil.toSet((Object[])new String[]{COMPLEX_TYPE, GROUP, ATTRIBUTE_GROUP});
            if (COMPLEX_ELEMENTS.contains(nodeName)) {
                this.addDescriptor(new ComplexTypeDescriptor(nameAttribute));
                continue;
            }
            if (SIMPLE_TYPE.equals(nodeName)) {
                this.addDescriptor(new SimpleTypeDescriptor(nameAttribute));
                continue;
            }
            if (ELEMENT.equals(nodeName)) {
                String typeName = element.getAttribute(TYPE);
                if (!StringUtil.isEmpty((String)typeName)) {
                    TypeDescriptor elementType = this.dataModel.getTypeDescriptor(typeName);
                    if (elementType instanceof SimpleTypeDescriptor) {
                        this.addDescriptor(new SimpleTypeDescriptor(nameAttribute));
                        continue;
                    }
                    if (elementType instanceof SimpleTypeDescriptor) {
                        this.addDescriptor(new ComplexTypeDescriptor(nameAttribute));
                        continue;
                    }
                    this.addDescriptor(new UnresolvedTypeDescriptor(nameAttribute, typeName));
                    continue;
                }
                if (XMLUtil.getChildElements((Element)element, (boolean)false, (String)COMPLEX_TYPE).length > 0) {
                    this.addDescriptor(new ComplexTypeDescriptor(nameAttribute));
                    continue;
                }
                if (XMLUtil.getChildElements((Element)element, (boolean)false, (String)SIMPLE_TYPE).length > 0) {
                    this.addDescriptor(new SimpleTypeDescriptor(nameAttribute));
                    continue;
                }
                this.addDescriptor(new ComplexTypeDescriptor(nameAttribute));
                continue;
            }
            if (ANNOTATION.equals(nodeName)) {
                this.parseDocumentAnnotation(element);
                continue;
            }
            if (IMPORT.equals(nodeName)) {
                this.parseImport(element);
                continue;
            }
            if (!INCLUDE.equals(nodeName)) continue;
            this.parseStructureOfInclude(element);
        }
        this.resolveTypes();
    }

    private void resolveTypes() {
        boolean unresolved = false;
        do {
            for (TypeDescriptor type : this.typeMap.values()) {
                if (!(type instanceof UnresolvedTypeDescriptor)) continue;
                TypeDescriptor parent = type.getParent();
                if (parent instanceof SimpleTypeDescriptor) {
                    this.addDescriptor(new SimpleTypeDescriptor(type.getName(), type.getParentName()));
                    continue;
                }
                if (parent instanceof ComplexTypeDescriptor) {
                    this.addDescriptor(new ComplexTypeDescriptor(type.getName(), type.getParentName()));
                    continue;
                }
                if (parent == null) {
                    throw new ConfigurationError("parentType " + type.getParentName() + " not found for " + type.getName());
                }
                unresolved = true;
            }
        } while (unresolved);
    }

    private void parseDetails(Document document) throws IOException {
        Element[] childElements;
        logger.debug((Object)"parseDetails()");
        Element root = document.getDocumentElement();
        for (Element element : childElements = XMLUtil.getChildElements((Element)root)) {
            String nodeName = XMLUtil.localName((Element)element);
            if (ELEMENT.equals(nodeName)) {
                this.parseTopLevelElement(element);
                continue;
            }
            if (COMPLEX_TYPE.equals(nodeName)) {
                this.parseComplexType(element, null, true);
                continue;
            }
            if (SIMPLE_TYPE.equals(nodeName)) {
                this.addDescriptor(this.parseSimpleType(null, element));
                continue;
            }
            if (GROUP.equals(nodeName)) {
                this.parseGroup(element);
                continue;
            }
            if (ATTRIBUTE_GROUP.equals(nodeName)) {
                this.parseAttributeGroup(element);
                continue;
            }
            if (IMPORT.equals(nodeName)) {
                this.parseImport(element);
                continue;
            }
            if (INCLUDE.equals(nodeName)) {
                this.parseDetailsOfInclude(element);
                continue;
            }
            if (ANNOTATION.equals(nodeName)) continue;
            throw this.unsupportedElementType(element, root);
        }
    }

    private void parseDocumentAnnotation(Element element) {
        Annotation annotation = new Annotation(element);
        Element appInfo = annotation.getAppInfo();
        if (appInfo == null) {
            return;
        }
        for (Element child : XMLUtil.getChildElements((Element)appInfo)) {
            String childName = XMLUtil.localName((Element)child);
            if (INCLUDE.equals(childName)) {
                String filename = this.parser.parseInclude(child);
                this.propertiesFiles.add(filename);
                continue;
            }
            if ("bean".equals(childName)) {
                this.parser.parseBean(child);
                continue;
            }
            throw new UnsupportedOperationException("Document annotation type not supported: " + child.getNodeName());
        }
    }

    private ComplexTypeDescriptor parseComplexType(Element complexType, String parentName, boolean global) {
        Element[] children;
        String name;
        String string = name = parentName != null ? parentName : complexType.getAttribute(NAME);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseComplexType(" + name + ')'));
        }
        if (name == null) {
            throw new ConfigurationError("unnamed complex type");
        }
        ComplexTypeDescriptor descriptor = new ComplexTypeDescriptor(name);
        Annotation annotation = null;
        for (Element child : children = XMLUtil.getChildElements((Element)complexType)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (ANNOTATION.equals(nodeName)) {
                annotation = new Annotation(child);
                continue;
            }
            if (SEQUENCE.equals(nodeName)) {
                this.parseSequence(child, descriptor);
                continue;
            }
            if (COMPLEX_CONTENT.equals(nodeName)) {
                this.parseComplexContent(child, descriptor);
                continue;
            }
            if (ALL.equals(nodeName)) {
                this.parseAll(child, descriptor);
                continue;
            }
            if (SIMPLE_CONTENT.equals(nodeName)) {
                this.parseSimpleContent(child, descriptor);
                continue;
            }
            if (ATTRIBUTE.equals(nodeName)) {
                this.parseAttribute(child, descriptor);
                continue;
            }
            if (ATTRIBUTE_GROUP.equals(nodeName)) {
                ComplexTypeDescriptor group = this.parseAttributeGroup(child);
                for (ComponentDescriptor component : group.getComponents()) {
                    descriptor.addComponent(component);
                }
                continue;
            }
            throw this.unsupportedElementType(child, complexType);
        }
        descriptor = this.parseComplexTypeAppinfo(descriptor, annotation);
        if (global) {
            this.addDescriptor(descriptor);
        }
        return descriptor;
    }

    private ComplexTypeDescriptor parseComplexTypeAppinfo(ComplexTypeDescriptor descriptor, Annotation annotation) {
        if (annotation == null || annotation.getAppInfo() == null) {
            return descriptor;
        }
        Element appInfo = annotation.getAppInfo();
        Element[] infos = XMLUtil.getChildElements((Element)appInfo);
        if (infos.length > 1) {
            throw new ConfigurationError("Cannot handle more than one appinfo in a complex type");
        }
        Element info = infos[0];
        this.parser.parseComplexTypeChild(info, descriptor);
        return descriptor;
    }

    private void parseComplexContent(Element complexContent, ComplexTypeDescriptor owner) {
        Element[] children;
        for (Element child : children = XMLUtil.getChildElements((Element)complexContent)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (EXTENSION.equals(nodeName)) {
                this.parseExtension(child, owner);
                continue;
            }
            if (RESTRICTION.equals(nodeName)) {
                this.parseComplexRestriction(child, owner);
                continue;
            }
            throw this.unsupportedElementType(child, complexContent);
        }
    }

    private void parseComplexRestriction(Element restrictionElement, ComplexTypeDescriptor owner) {
        Element[] children;
        for (Element child : children = XMLUtil.getChildElements((Element)restrictionElement)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (!ATTRIBUTE.equals(nodeName)) {
                throw this.unsupportedElementType(child, restrictionElement);
            }
            this.parseAttribute(child, owner);
        }
    }

    private ComplexTypeDescriptor parseSimpleContent(Element simpleContentElement, ComplexTypeDescriptor complexType) {
        Annotation annotation = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"parseSimpleContent()");
        }
        for (Element child : XMLUtil.getChildElements((Element)simpleContentElement)) {
            String localName = XMLUtil.localName((Element)child);
            if (ANNOTATION.equals(localName)) {
                annotation = new Annotation(child);
                continue;
            }
            if (RESTRICTION.equals(localName)) {
                this.parseSimpleContentRestriction(child, complexType);
                continue;
            }
            if (EXTENSION.equals(localName)) {
                this.parseSimpleContentExtension(child, complexType);
                continue;
            }
            throw this.unsupportedElementType(child, simpleContentElement);
        }
        if (annotation != null && annotation.getAppInfo() != null) {
            complexType = this.parseComplexTypeAppinfo(complexType, annotation);
        }
        return complexType;
    }

    private void parseSimpleContentRestriction(Element restriction, ComplexTypeDescriptor complexType) {
        String baseName = restriction.getAttribute(BASE);
        Assert.notNull((Object)baseName, (String)"base attribute");
        TypeDescriptor base = this.dataModel.getTypeDescriptor(baseName);
        Assert.notNull((Object)base, (String)"base type");
        if (!(base instanceof ComplexTypeDescriptor)) {
            throw new ConfigurationError("Expected ComplexTypeDescriptor for " + baseName + ", found: " + base.getClass().getSimpleName());
        }
        complexType.setParent(base);
        SimpleTypeDescriptor content = (SimpleTypeDescriptor)complexType.getComponent("__SIMPLE_CONTENT").getLocalType(false);
        Assert.notNull((Object)content, (String)"content");
        this.parseRestrictionChildren(restriction, content);
    }

    private void parseSimpleContentExtension(Element extension, ComplexTypeDescriptor complexType) {
        String baseName = extension.getAttribute(BASE);
        Assert.notNull((Object)baseName, (String)"base attribute");
        TypeDescriptor base = this.dataModel.getTypeDescriptor(baseName);
        Assert.notNull((Object)base, (String)"base type");
        if (base instanceof SimpleTypeDescriptor) {
            complexType.addComponent(new PartDescriptor("__SIMPLE_CONTENT", baseName, null, 1L, 1L));
        } else if (base instanceof ComplexTypeDescriptor) {
            complexType.setParentName(baseName);
        } else {
            throw new UnsupportedOperationException("not a supported type: " + base.getClass());
        }
        this.parseAttributes(extension, complexType);
    }

    private void parseExtension(Element extension, ComplexTypeDescriptor descriptor) {
        String base = extension.getAttribute(BASE);
        descriptor.setParentName(base);
        this.parseAttributes(extension, descriptor);
    }

    private void parseAttributes(Element extension, ComplexTypeDescriptor owner) {
        Element[] children;
        for (Element child : children = XMLUtil.getChildElements((Element)extension)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (!ATTRIBUTE.equals(nodeName)) {
                throw this.unsupportedElementType(child, extension);
            }
            this.parseAttribute(child, owner);
        }
    }

    private TypeDescriptor parseTopLevelElement(Element element) {
        String type;
        Element[] children;
        String name = element.getAttribute(NAME);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseElement(" + element.getAttribute(NAME) + ')'));
        }
        TypeDescriptor descriptor = null;
        Annotation annotation = null;
        for (Element child : children = XMLUtil.getChildElements((Element)element)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (COMPLEX_TYPE.equals(nodeName)) {
                descriptor = this.parseComplexType(child, name, false);
                continue;
            }
            if (SIMPLE_TYPE.equals(nodeName)) {
                descriptor = this.parseSimpleType(name, child);
                continue;
            }
            if (KEY.equals(nodeName)) {
                this.parseKey(child);
                continue;
            }
            if (KEYREF.equals(nodeName)) {
                this.parseKeyRef(child);
                continue;
            }
            if (ANNOTATION.equals(nodeName)) {
                annotation = new Annotation(child);
                continue;
            }
            throw this.unsupportedElementType(child, element);
        }
        if (descriptor == null && !StringUtil.isEmpty((String)(type = element.getAttribute(TYPE)))) {
            descriptor = this.parseTopLevelElementWithType(element);
        }
        if ((descriptor = (TypeDescriptor)this.parseElementAppInfo(descriptor, annotation)) == null) {
            descriptor = new ComplexTypeDescriptor(name);
        }
        this.addDescriptor(descriptor);
        return descriptor;
    }

    private ComponentDescriptor parseContainedElement(Element element, ComplexTypeDescriptor owner) {
        Element[] children;
        String name = element.getAttribute(NAME);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseElement(" + element.getAttribute(NAME) + ')'));
        }
        if (owner == null) {
            throw new RuntimeException("No owner provided");
        }
        PartDescriptor descriptor = null;
        if (!StringUtil.isEmpty((String)element.getAttribute(REF))) {
            descriptor = this.parseElementRef(element);
        }
        Annotation annotation = null;
        for (Element child : children = XMLUtil.getChildElements((Element)element)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (COMPLEX_TYPE.equals(nodeName)) {
                ComplexTypeDescriptor type = this.parseComplexType(child, name, false);
                descriptor = new PartDescriptor(name, type);
                continue;
            }
            if (SIMPLE_TYPE.equals(nodeName)) {
                SimpleTypeDescriptor simpleType = this.parseSimpleType(name, child);
                ComplexTypeDescriptor complexType = this.wrapSimpleTypeWithComplexType(simpleType);
                descriptor = new PartDescriptor(name, complexType);
                continue;
            }
            if (KEY.equals(nodeName)) {
                this.parseKey(child);
                continue;
            }
            if (KEYREF.equals(nodeName)) {
                this.parseKeyRef(child);
                continue;
            }
            if (UNIQUE.equals(nodeName)) {
                this.parseUnique(child);
                continue;
            }
            if (ANNOTATION.equals(nodeName)) {
                annotation = new Annotation(child);
                continue;
            }
            throw this.unsupportedElementType(child, element);
        }
        if (descriptor == null) {
            String type = element.getAttribute(TYPE);
            if (!StringUtil.isEmpty((String)type)) {
                descriptor = this.parseElementWithType(element);
            }
        } else {
            descriptor = this.parseElementAppInfo(descriptor, annotation);
        }
        if ("false".equals(element.getAttribute("nillable"))) {
            descriptor.setNullable(false);
        }
        if (descriptor == null) {
            descriptor = new PartDescriptor(name, "string");
        }
        if (descriptor != null) {
            this.parseOccurrences(element, descriptor);
        }
        owner.addComponent(descriptor);
        return descriptor;
    }

    private ComplexTypeDescriptor wrapSimpleTypeWithComplexType(SimpleTypeDescriptor simpleType) {
        ComplexTypeDescriptor complexType = new ComplexTypeDescriptor(simpleType.getName());
        complexType.addComponent(new PartDescriptor("__SIMPLE_CONTENT", simpleType));
        return complexType;
    }

    private void parseUnique(Element child) {
        logger.warn((Object)"<unique> is not supported. Please define own annotations or setup for uniqueness assurance");
    }

    private PartDescriptor parseElementRef(Element element) {
        PartDescriptor descriptor;
        String refName = element.getAttribute(REF);
        if (StringUtil.isEmpty((String)refName)) {
            throw new ConfigurationError("no ref specified in element");
        }
        TypeDescriptor type = this.dataModel.getTypeDescriptor(refName);
        if (type instanceof SimpleTypeDescriptor) {
            ComplexTypeDescriptor complexType = new ComplexTypeDescriptor(refName);
            complexType.addComponent(new PartDescriptor("__SIMPLE_CONTENT", refName));
            descriptor = new PartDescriptor(refName, complexType);
        } else {
            descriptor = new PartDescriptor(refName, refName);
        }
        this.parseOccurrences(element, descriptor);
        return descriptor;
    }

    private <T extends FeatureDescriptor> T parseElementAppInfo(T descriptor, Annotation annotation) {
        Element[] infos;
        if (annotation == null || annotation.getAppInfo() == null) {
            return (T)descriptor;
        }
        Element appInfo = annotation.getAppInfo();
        for (Element info : infos = XMLUtil.getChildElements((Element)appInfo)) {
            String childName = XMLUtil.localName((Element)info);
            if ("bean".equals(childName)) {
                this.parser.parseBean(info);
                continue;
            }
            if ("variable".equals(childName)) {
                this.parser.parseVariable(info, (ComplexTypeDescriptor)descriptor);
                continue;
            }
            if (ATTRIBUTE.equals(childName)) {
                descriptor = this.parser.parsePart(info, null, false, (PartDescriptor)descriptor);
                continue;
            }
            if ("part".equals(childName)) {
                descriptor = this.parser.parsePart(info, null, true, (PartDescriptor)descriptor);
                continue;
            }
            if (descriptor instanceof ComplexTypeDescriptor) {
                descriptor = this.parser.parseComplexType(info, (ComplexTypeDescriptor)descriptor);
                continue;
            }
            if (descriptor instanceof SimpleTypeDescriptor) {
                descriptor = this.parser.parseSimpleType(info, (SimpleTypeDescriptor)descriptor);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported element (" + childName + ") or type: " + descriptor.getClass().getName());
        }
        return (T)descriptor;
    }

    private TypeDescriptor parseTopLevelElementWithType(Element element) {
        String name = element.getAttribute(NAME);
        String typeName = element.getAttribute(TYPE);
        TypeDescriptor type = this.getType(typeName);
        if (type == null) {
            type = this.getType(name);
        }
        if (type != null) {
            if (type instanceof SimpleTypeDescriptor) {
                return new SimpleTypeDescriptor(name, typeName);
            }
            if (type instanceof ComplexTypeDescriptor) {
                return new ComplexTypeDescriptor(name, typeName);
            }
            throw new UnsupportedOperationException("Unsupported descriptor: " + type);
        }
        throw new UnsupportedOperationException("Unsupported type: " + typeName);
    }

    private PartDescriptor parseElementWithType(Element element) {
        PartDescriptor refDesc;
        String name = element.getAttribute(NAME);
        String typeName = element.getAttribute(TYPE);
        TypeDescriptor type = this.getType(typeName);
        if (type == null) {
            throw new ConfigurationError("Undefined type: " + typeName);
        }
        if (type instanceof SimpleTypeDescriptor) {
            SimpleTypeDescriptor localType = new SimpleTypeDescriptor(name, typeName);
            ComplexTypeDescriptor contentType = this.wrapSimpleTypeWithComplexType(localType);
            refDesc = new PartDescriptor(name, contentType);
            Element anno = XMLUtil.getChildElement((Element)element, (boolean)false, (boolean)false, (String)ANNOTATION);
            if (anno != null) {
                this.parseSimpleTypeAppinfo(new Annotation(anno), localType);
            }
        } else {
            ComplexTypeDescriptor localType = new ComplexTypeDescriptor(name, typeName);
            refDesc = new PartDescriptor(name, localType);
            Element anno = XMLUtil.getChildElement((Element)element, (boolean)false, (boolean)false, (String)ANNOTATION);
            if (anno != null) {
                refDesc = this.parseAttributeAppinfo(new Annotation(anno), refDesc);
            }
        }
        this.parseOccurrences(element, refDesc);
        return refDesc;
    }

    private TypeDescriptor getType(String typeName) {
        int sep = typeName.indexOf(58);
        if (sep < 0) {
            return this.dataModel.getTypeDescriptor(typeName);
        }
        String nsAlias = typeName.substring(0, sep);
        String namespace = this.getNamespaceForAlias(nsAlias);
        String typeInNs = typeName.substring(sep + 1);
        TypeDescriptor type = this.dataModel.getTypeDescriptor(namespace, typeInNs);
        return type;
    }

    private String getNamespaceForAlias(String nsAlias) {
        return this.namespaces.get(nsAlias);
    }

    private void parseOccurrences(Element element, InstanceDescriptor descriptor) {
        Long minOccurs = XMLUtil.getLongAttribute((Element)element, (String)"minOccurs", (long)1L);
        String maxOccursString = element.getAttribute("maxOccurs");
        Long maxOccurs = 1L;
        if (!StringUtil.isEmpty((String)maxOccursString)) {
            maxOccurs = "unbounded".equals(maxOccursString) ? null : Long.valueOf(Long.parseLong(maxOccursString));
        }
        descriptor.setMinCount(minOccurs);
        descriptor.setMaxCount(maxOccurs);
    }

    private void parseKeyRef(Element child) {
        logger.warn((Object)("KeyRefs are not supported, yet. Ignoring keyRef: " + child.getAttribute(NAME)));
    }

    private void parseKey(Element child) {
        logger.warn((Object)("Keys are not supported, yet. Ignoring key: " + child.getAttribute(NAME)));
    }

    private ComponentDescriptor parseAttribute(Element attributeElement, ComplexTypeDescriptor owner) {
        String fixed;
        String name = attributeElement.getAttribute(NAME);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseAttribute(" + name + ')'));
        }
        if (StringUtil.isEmpty((String)name)) {
            throw new ConfigurationError("Unnamed attribute");
        }
        Element[] children = XMLUtil.getChildElements((Element)attributeElement);
        String use = attributeElement.getAttribute("use");
        Boolean nullable = "required".equals(use) ? Boolean.FALSE : null;
        Annotation annotation = null;
        PartDescriptor descriptor = null;
        for (Element child : children) {
            String nodeName = XMLUtil.localName((Element)child);
            if (ANNOTATION.equals(nodeName)) {
                annotation = new Annotation(child);
                continue;
            }
            if (SIMPLE_TYPE.equals(nodeName)) {
                descriptor = new PartDescriptor(name, this.parseSimpleType(null, child));
                continue;
            }
            throw this.unsupportedElementType(child, attributeElement);
        }
        String type = attributeElement.getAttribute(TYPE);
        if (descriptor == null && type != null) {
            descriptor = new PartDescriptor(name, type);
            if (nullable != null && !nullable.booleanValue()) {
                descriptor.setNullable(false);
            }
        }
        if (annotation != null && annotation.getAppInfo() != null) {
            descriptor = this.parseAttributeAppinfo(annotation, descriptor);
        }
        if (!StringUtil.isEmpty((String)(fixed = attributeElement.getAttribute("fixed")))) {
            descriptor.getLocalType(false).setValues(fixed);
        } else {
            String defaultValue = attributeElement.getAttribute("default");
            if (!StringUtil.isEmpty((String)defaultValue)) {
                descriptor.getLocalType(false).setValues(defaultValue);
            }
        }
        descriptor.setCount(1L);
        if ("prohibited".equals(attributeElement.getAttribute("use"))) {
            descriptor.setMode(Mode.ignored);
        }
        if (descriptor == null) {
            throw new ConfigurationError("Unable to parse attribute " + name);
        }
        owner.addComponent(descriptor);
        return descriptor;
    }

    private <T extends ComponentDescriptor> T parseAttributeAppinfo(Annotation annotation, T descriptor) {
        Element appInfo = annotation.getAppInfo();
        if (appInfo == null) {
            return descriptor;
        }
        Element[] infos = XMLUtil.getChildElements((Element)appInfo);
        if (infos.length > 1) {
            throw new ConfigurationError("Cannot handle more than one appinfo in a simple type");
        }
        if (infos.length == 0) {
            return descriptor;
        }
        Element info = infos[0];
        return (T)this.parser.parseSimpleTypeComponent(info, null, descriptor);
    }

    private SimpleTypeDescriptor parseSimpleType(String name, Element simpleType) {
        Annotation annotation = null;
        SimpleTypeDescriptor descriptor = null;
        if (name == null) {
            name = simpleType.getAttribute(NAME);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseSimpleType(" + name + ')'));
        }
        for (Element child : XMLUtil.getChildElements((Element)simpleType)) {
            String localName = XMLUtil.localName((Element)child);
            if (ANNOTATION.equals(localName)) {
                annotation = new Annotation(child);
                continue;
            }
            if (UNION.equals(localName)) {
                descriptor = this.parseUnion(child, name);
                continue;
            }
            if (RESTRICTION.equals(localName)) {
                descriptor = this.parseSimpleTypeRestriction(child, name);
                continue;
            }
            throw this.unsupportedElementType(child, simpleType);
        }
        if (descriptor == null) {
            String type = simpleType.getAttribute(TYPE);
            descriptor = new SimpleTypeDescriptor(name, type);
        }
        if (annotation != null && annotation.getAppInfo() != null) {
            descriptor = this.parseSimpleTypeAppinfo(annotation, descriptor);
        }
        return descriptor;
    }

    private SimpleTypeDescriptor parseSimpleTypeAppinfo(Annotation annotation, SimpleTypeDescriptor descriptor) {
        Element appInfo = annotation.getAppInfo();
        Element[] infos = XMLUtil.getChildElements((Element)appInfo);
        if (infos.length > 1) {
            throw new ConfigurationError("Cannot handle more than one appinfo in a simple type");
        }
        this.parser.parseSimpleType(infos[0], descriptor);
        return descriptor;
    }

    private SimpleTypeDescriptor parseUnion(Element union, String name) {
        Element[] children;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseUnion(" + name + ')'));
        }
        UnionSimpleTypeDescriptor descriptor = new UnionSimpleTypeDescriptor(name);
        for (Element child : children = XMLUtil.getChildElements((Element)union)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (!SIMPLE_TYPE.equals(nodeName)) {
                throw this.unsupportedElementType(child, union);
            }
            descriptor.addAlternative(this.parseSimpleType(null, child));
        }
        String memberTypes = union.getAttribute("memberTypes");
        if (!StringUtil.isEmpty((String)memberTypes)) {
            String[] tokens;
            for (String token : tokens = StringUtil.tokenize((String)memberTypes, (char)' ')) {
                if (StringUtil.isEmpty((String)token)) continue;
                descriptor.addAlternative(new SimpleTypeDescriptor("_local", token));
            }
        }
        return descriptor;
    }

    private SimpleTypeDescriptor parseSimpleTypeRestriction(Element restriction, String name) {
        String base = XMLUtil.localName((String)restriction.getAttribute(BASE));
        SimpleTypeDescriptor descriptor = new SimpleTypeDescriptor(name, base);
        this.parseRestrictionChildren(restriction, descriptor);
        return descriptor;
    }

    private void parseRestrictionChildren(Element restriction, SimpleTypeDescriptor descriptor) {
        Element[] children;
        for (Element child : children = XMLUtil.getChildElements((Element)restriction)) {
            String nodeName = XMLUtil.localName((Element)child);
            String value = child.getAttribute(VALUE);
            if (ENUMERATION.equals(nodeName)) {
                descriptor.addValue(value);
                continue;
            }
            if (MIN_INCLUSIVE.equals(nodeName)) {
                descriptor.setMin(value);
                continue;
            }
            if (MAX_INCLUSIVE.equals(nodeName)) {
                descriptor.setMax(value);
                continue;
            }
            if (LENGTH.equals(nodeName)) {
                int length = Integer.parseInt(value);
                descriptor.setMinLength(length);
                descriptor.setMaxLength(length);
                continue;
            }
            if (BeanUtil.hasProperty(descriptor.getClass(), (String)nodeName)) {
                BeanUtil.setPropertyValue((Object)descriptor, (String)nodeName, (Object)value, (boolean)false);
                continue;
            }
            logger.warn((Object)("Ignoring restriction " + nodeName + ": " + value));
        }
    }

    private void parseImport(Element importElement) {
        logger.debug((Object)"parseImport()");
        throw this.unsupportedElementType(importElement, null);
    }

    private void parseStructureOfInclude(Element includeElement) throws IOException {
        logger.debug((Object)"parseStructureOfInclude()");
        assert (INCLUDE.equals(XMLUtil.localName((Element)includeElement)));
        String location = includeElement.getAttribute("schemaLocation");
        this.parseStructure(XMLUtil.parse((String)location));
    }

    private void parseDetailsOfInclude(Element includeElement) throws IOException {
        logger.debug((Object)"parseDetailsOfInclude()");
        assert (INCLUDE.equals(XMLUtil.localName((Element)includeElement)));
        String location = includeElement.getAttribute("schemaLocation");
        this.parseDetails(XMLUtil.parse((String)location));
    }

    private void parseGroup(Element group) {
        logger.debug((Object)"parseGroup()");
        throw this.unsupportedElementType(group, null);
    }

    private ComplexTypeDescriptor parseAttributeGroup(Element group) {
        logger.debug((Object)"parseAttributeGroup()");
        String refName = XMLUtil.normalizedAttributeValue((Element)group, (String)REF);
        if (refName != null) {
            ComplexTypeDescriptor refdType = (ComplexTypeDescriptor)this.getType(refName);
            if (refdType == null) {
                throw new ConfigurationError("referenced attributeGroup not found: " + refName);
            }
            return refdType;
        }
        String name = XMLUtil.normalizedAttributeValue((Element)group, (String)NAME);
        ComplexTypeDescriptor type = new ComplexTypeDescriptor(name);
        Annotation annotation = null;
        for (Element child : XMLUtil.getChildElements((Element)group)) {
            String elType = XMLUtil.localName((Element)child);
            if (ATTRIBUTE.equals(elType)) {
                this.parseAttribute(child, type);
                continue;
            }
            if (ATTRIBUTE_GROUP.equals(elType)) {
                ComplexTypeDescriptor childGroup = this.parseAttributeGroup(child);
                for (ComponentDescriptor component : childGroup.getComponents()) {
                    type.addComponent(component);
                }
                continue;
            }
            if (ANNOTATION.equals(elType)) {
                annotation = new Annotation(child);
                continue;
            }
            throw this.unsupportedElementType(child, group);
        }
        if (annotation != null && annotation.getAppInfo() != null) {
            logger.warn((Object)("ignoring appinfo of attributeGroup: " + name));
        }
        this.addDescriptor(type);
        return type;
    }

    private void parseSequence(Element sequence, ComplexTypeDescriptor owner) {
        logger.debug((Object)"parseSequence()");
        this.parseComponentGroupChildren(sequence, owner);
    }

    private void parseChoice(Element choice, ComplexTypeDescriptor owner) {
        logger.debug((Object)"parseChoice()");
        AlternativeGroupDescriptor choiceDescriptor = new AlternativeGroupDescriptor(null);
        this.parseComponentGroupChildren(choice, choiceDescriptor);
        PartDescriptor partDescriptor = new PartDescriptor(null, choiceDescriptor);
        this.parseOccurrences(choice, partDescriptor);
        owner.addComponent(partDescriptor);
    }

    private void parseAll(Element all, ComplexTypeDescriptor owner) {
        logger.debug((Object)"parseAll()");
        this.parseComponentGroupChildren(all, owner);
    }

    private void parseComponentGroupChildren(Element choice, ComplexTypeDescriptor groupDescriptor) {
        Element[] children;
        for (Element child : children = XMLUtil.getChildElements((Element)choice)) {
            String nodeName = XMLUtil.localName((Element)child);
            if (ELEMENT.equals(nodeName)) {
                this.parseContainedElement(child, groupDescriptor);
                continue;
            }
            if (SEQUENCE.equals(nodeName)) {
                this.parseSequence(child, groupDescriptor);
                continue;
            }
            if (CHOICE.equals(nodeName)) {
                this.parseChoice(child, groupDescriptor);
                continue;
            }
            throw this.unsupportedElementType(child, choice);
        }
    }

    private UnsupportedOperationException unsupportedElementType(Element element, Element parent) {
        String message = "Element type " + element.getNodeName() + " not supported";
        if (parent != null) {
            message = message + " in " + parent.getNodeName();
        }
        return new UnsupportedOperationException(message);
    }
}

