/*
 * Decompiled with CFR 0.152.
 */
package org.databene.platform.xml;

import org.databene.model.data.DefaultDescriptorProvider;
import org.databene.model.data.SimpleTypeDescriptor;

public class XMLSchemaNativeTypeProvider
extends DefaultDescriptorProvider {
    private static final String REGEX_YEAR = "\\-?\\d{4,}";
    private static final String REGEX_MONTH_NUMBER = "(0[1-9]|1[0-2])";
    private static final String REGEX_DAY_OF_MONTH = "(0[1-9]|[1-2][0-9]|3[01])";
    private static final String REGEX_TIMEZONE = "(Z|[+\\-]\\d{2}:\\d{2})";
    private static final String REGEX_OPTIONAL_TIMEZONE = "(Z|[+\\-]\\d{2}:\\d{2})?";

    public XMLSchemaNativeTypeProvider(String id) {
        super(id);
        this.addDescriptor(new SimpleTypeDescriptor("string", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("boolean", "boolean"));
        this.addDescriptor(new SimpleTypeDescriptor("byte", "byte"));
        this.addDescriptor(new SimpleTypeDescriptor("short", "short"));
        this.addDescriptor(new SimpleTypeDescriptor("int", "int"));
        this.addDescriptor(new SimpleTypeDescriptor("long", "long"));
        this.addDescriptor(new SimpleTypeDescriptor("float", "float"));
        this.addDescriptor(new SimpleTypeDescriptor("double", "double"));
        this.addDescriptor(new SimpleTypeDescriptor("date", "date"));
        this.addDescriptor(new SimpleTypeDescriptor("time", "time"));
        this.addDescriptor(new SimpleTypeDescriptor("integer", "int"));
        this.addDescriptor(new SimpleTypeDescriptor("nonPositiveInteger", "int").withMin("-2147483648").withMax("0"));
        this.addDescriptor(new SimpleTypeDescriptor("negativeInteger", "int").withMin("-2147483648").withMax("-1"));
        this.addDescriptor(new SimpleTypeDescriptor("nonNegativeInteger", "int").withMin("0"));
        this.addDescriptor(new SimpleTypeDescriptor("positiveInteger", "int").withMin("1"));
        this.addDescriptor(new SimpleTypeDescriptor("unsignedLong", "big_decimal").withMin("0").withMax("9223372036854775807"));
        this.addDescriptor(new SimpleTypeDescriptor("unsignedInt", "long").withMin("0").withMax("4294967295"));
        this.addDescriptor(new SimpleTypeDescriptor("unsignedShort", "int").withMin("0").withMax("32767"));
        this.addDescriptor(new SimpleTypeDescriptor("unsignedByte", "short").withMin("0").withMax("256"));
        this.addDescriptor(new SimpleTypeDescriptor("decimal", "big_decimal"));
        this.addDescriptor(new SimpleTypeDescriptor("precisionDecimal", "big_decimal"));
        this.addDescriptor(new SimpleTypeDescriptor("dateTime", "timestamp"));
        this.addDescriptor(new SimpleTypeDescriptor("duration", "string").withPattern("\\-?P(\\d+Y)?(\\d+M)?(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d+S)?)?"));
        this.addDescriptor(new SimpleTypeDescriptor("gYearMonth", "string").withPattern("\\-?\\d{4,}\\-(0[1-9]|1[0-2])(Z|[+\\-]\\d{2}:\\d{2})?"));
        this.addDescriptor(new SimpleTypeDescriptor("gYear", "string").withPattern("\\-?\\d{4,}(Z|[+\\-]\\d{2}:\\d{2})?"));
        this.addDescriptor(new SimpleTypeDescriptor("gMonthDay", "string").withPattern("(0[1-9]|1[0-2])\\-(0[1-9]|[1-2][0-9]|3[01])(Z|[+\\-]\\d{2}:\\d{2})?"));
        this.addDescriptor(new SimpleTypeDescriptor("gDay", "string").withPattern("(0[1-9]|[1-2][0-9]|3[01])(Z|[+\\-]\\d{2}:\\d{2})?"));
        this.addDescriptor(new SimpleTypeDescriptor("gMonth", "int").withPattern("(0[1-9]|1[0-2])(Z|[+\\-]\\d{2}:\\d{2})?"));
        this.addDescriptor(new SimpleTypeDescriptor("hexBinary", "string").withPattern("([0-9a-fA-F]{2})*"));
        this.addDescriptor(new SimpleTypeDescriptor("base64Binary", "string").withPattern("[a-zA-Z0-9+/= ]*"));
        this.addDescriptor(new SimpleTypeDescriptor("anyURI", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("QName", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("NOTATION", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("normalizedString", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("token", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("language", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("NMTOKEN", "string").withPattern("[A-Za-z:_\\-\\.0-9]*"));
        this.addDescriptor(new SimpleTypeDescriptor("NMTOKENS", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("Name", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("NCName", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("ID", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("IDREFS", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("ENTITY", "string"));
        this.addDescriptor(new SimpleTypeDescriptor("ENTITIES", "string"));
    }
}

