/*
 * Decompiled with CFR 0.152.
 */
package org.databene.task;

import org.databene.commons.Context;
import org.databene.commons.ErrorHandler;
import org.databene.task.Task;

public abstract class AbstractTask
implements Task {
    protected String taskName;
    protected Context context;
    protected ErrorHandler errorHandler;

    protected AbstractTask() {
        this(null, null);
    }

    protected AbstractTask(ErrorHandler errorHandler) {
        this(null, errorHandler);
    }

    protected AbstractTask(String taskName) {
        this(taskName, null);
    }

    protected AbstractTask(String taskName, ErrorHandler errorHandler) {
        if (taskName == null) {
            taskName = this.getClass().getSimpleName();
        }
        this.setTaskName(taskName);
        if (errorHandler == null) {
            errorHandler = new ErrorHandler(taskName);
        }
        this.errorHandler = errorHandler;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void init(Context context) {
        this.context = context;
    }

    public boolean wantsToRun() {
        return true;
    }

    public void destroy() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.taskName + ']';
    }
}

