/*
 * Decompiled with CFR 0.152.
 */
package org.databene.task;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ConfigurationError;
import org.databene.task.AbstractTask;
import org.databene.task.LoopedTask;
import org.databene.task.PageListener;
import org.databene.task.Parallelizable;
import org.databene.task.Task;
import org.databene.task.TaskRunnable;
import org.databene.task.ThreadSafe;

public class PagedTask
extends AbstractTask
implements Thread.UncaughtExceptionHandler {
    private static final Log logger = LogFactory.getLog(PagedTask.class);
    protected Task realTask;
    private PageListener listener;
    private long totalInvocations;
    private long pageSize;
    private int threadCount;
    private ExecutorService executor;
    private Throwable exception;

    public PagedTask() {
        this((Task)null);
    }

    public PagedTask(Task realTask) {
        this(realTask, 1L);
    }

    public PagedTask(Task realTask, long totalInvocations) {
        this(realTask, totalInvocations, null, 1L);
    }

    public PagedTask(Task realTask, long totalInvocations, PageListener listener, long pageSize) {
        this(realTask, totalInvocations, listener, pageSize, 1, Executors.newSingleThreadExecutor());
    }

    public PagedTask(Task realTask, long totalInvocations, PageListener listener, long pageSize, int threads, ExecutorService executor) {
        this.realTask = realTask;
        this.listener = listener;
        this.totalInvocations = totalInvocations;
        this.pageSize = pageSize;
        this.threadCount = threads;
        this.executor = executor;
    }

    public long getTotalInvocations() {
        return this.totalInvocations;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void run() {
        if (this.totalInvocations == 0L) {
            return;
        }
        this.exception = null;
        int invocationCount = 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Running PagedTask[" + this.getTaskName() + "]"));
        }
        int currentPageNo = 0;
        while (this.workPending(currentPageNo)) {
            try {
                this.pageStarting(currentPageNo);
                long currentPageSize = this.totalInvocations < 0L ? this.pageSize : Math.min(this.pageSize, this.totalInvocations - (long)invocationCount);
                invocationCount = this.threadCount > 1 ? (int)((long)invocationCount + this.runMultiThreaded(currentPageNo, currentPageSize)) : (int)((long)invocationCount + this.runSingleThreaded(currentPageSize));
                this.pageFinished(currentPageNo);
                if (this.exception != null) {
                    throw new RuntimeException(this.exception);
                }
                ++currentPageNo;
            }
            catch (Exception e) {
                this.errorHandler.handleError("Error in execution of task " + this.getTaskName(), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PagedTask " + this.getTaskName() + " finished"));
        }
    }

    public String getTaskName() {
        return this.realTask.getTaskName();
    }

    private long runMultiThreaded(int currentPageNo, long currentPageSize) {
        long localInvocationCount = 0L;
        int maxLoopsPerPage = (int)((currentPageSize + (long)this.threadCount - 1L) / (long)this.threadCount);
        int shorterLoops = (int)((long)(this.threadCount * maxLoopsPerPage) - currentPageSize);
        if (this.realTask instanceof ThreadSafe) {
            this.realTask.init(this.context);
        }
        CountDownLatch latch = new CountDownLatch(this.threadCount);
        for (int threadNo = 0; threadNo < this.threadCount; ++threadNo) {
            int loopSize = maxLoopsPerPage;
            if (this.totalInvocations >= 0L && threadNo >= this.threadCount - shorterLoops) {
                --loopSize;
            }
            if (loopSize > 0) {
                Task task = this.realTask;
                if (this.threadCount > 1 && !(task instanceof ThreadSafe)) {
                    if (task instanceof Parallelizable) {
                        task = this.cloneTask((Parallelizable)((Object)task));
                    } else {
                        throw new ConfigurationError("Since the task is not marked as thread-safe,it must either be used single-threaded or implement the Parallelizable interface");
                    }
                }
                task = new LoopedTask(task, loopSize);
                TaskRunnable thread = new TaskRunnable(task, this.realTask instanceof ThreadSafe ? null : this.context, latch);
                this.executor.execute(thread);
                localInvocationCount += (long)loopSize;
                continue;
            }
            latch.countDown();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Waiting for end of page " + (currentPageNo + 1) + " of " + this.getTaskName() + "..."));
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.realTask instanceof ThreadSafe) {
            this.realTask.destroy();
        }
        return localInvocationCount;
    }

    private long runSingleThreaded(long currentPageSize) {
        LoopedTask task = new LoopedTask(this.realTask, currentPageSize);
        task.init(this.context);
        task.run();
        task.destroy();
        return currentPageSize;
    }

    protected boolean workPending(int currentPageNo) {
        if (!this.realTask.wantsToRun()) {
            return false;
        }
        if (this.totalInvocations < 0L) {
            return true;
        }
        long pages = (this.totalInvocations + this.pageSize - 1L) / this.pageSize;
        return (long)currentPageNo < pages;
    }

    private Task cloneTask(Parallelizable task) {
        try {
            Method cloneMethod = task.getClass().getMethod("clone", new Class[0]);
            return (Task)cloneMethod.invoke((Object)task, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Execption occured in clone() method", e);
        }
    }

    protected void pageStarting(int currentPageNo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting page " + (currentPageNo + 1) + " of " + this.getTaskName() + " with pagesize=" + this.pageSize));
        }
        if (this.listener != null) {
            this.listener.pageStarting(currentPageNo, -1L);
        }
    }

    protected void pageFinished(int currentPageNo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Page " + (currentPageNo + 1) + " of " + this.getTaskName() + " finished"));
        }
        if (this.listener != null) {
            this.listener.pageFinished(currentPageNo, -1L);
        }
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.exception = e;
    }
}

