/*
 * Decompiled with CFR 0.152.
 */
package org.databene.task;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.document.csv.CSVLineIterator;
import org.databene.task.PageListener;
import org.databene.task.PagedTask;
import org.databene.task.Task;
import org.databene.task.TaskContext;

public class TaskRunner {
    private static final Log logger = LogFactory.getLog(TaskRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Task task, Context context, long invocations, PageListener pager, long pageSize, int threadCount, ExecutorService executor) {
        if (logger.isInfoEnabled()) {
            String invocationInfo = invocations == 1L ? "" : invocations + " times with page size " + pageSize + " in " + threadCount + " threads";
            logger.info((Object)("Running task " + task + " " + invocationInfo));
        }
        PagedTask pagedTask = new PagedTask(task, invocations, pager, pageSize, threadCount, executor);
        pagedTask.init(context);
        try {
            pagedTask.run();
        }
        finally {
            pagedTask.destroy();
        }
    }

    public static void runFromConfigFile(String urn) throws IOException {
        TaskContext context = new TaskContext();
        CSVLineIterator iterator = new CSVLineIterator(urn, ',');
        while (iterator.hasNext()) {
            String[] cells = iterator.next();
            if (cells.length == 0) continue;
            Class taskClass = BeanUtil.forName((String)cells[0]);
            Task task = (Task)BeanUtil.newInstance((Class)taskClass, (Object[])new Object[0]);
            int invocations = Integer.parseInt(cells[1]);
            int pageSize = Integer.parseInt(cells[2]);
            int threadCount = Integer.parseInt(cells[3]);
            TaskRunner.run(task, (Context)context, invocations, null, pageSize, threadCount, Executors.newCachedThreadPool());
        }
        iterator.close();
    }
}

