/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.lang.reflect.Array;
import org.databene.commons.ArrayUtil;
import org.databene.commons.converter.ToStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBuilder<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private Class<E> componentType;
    private E[] buffer;
    private int elementCount;

    public ArrayBuilder(Class<E> componentType) {
        this(componentType, 10);
    }

    public ArrayBuilder(Class<E> componentType, int initialCapacity) {
        this.componentType = componentType;
        this.buffer = this.createBuffer(initialCapacity);
    }

    public ArrayBuilder<E> append(E element) {
        if (this.buffer == null) {
            throw new UnsupportedOperationException("ArrayBuilder cannot be reused after invoking toArray()");
        }
        if (this.elementCount >= this.buffer.length - 1) {
            E[] newBuffer = this.createBuffer(this.buffer.length * 2);
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.elementCount++] = element;
        return this;
    }

    public E[] toArray() {
        E[] result = ArrayUtil.newInstance(this.componentType, this.elementCount);
        System.arraycopy(this.buffer, 0, result, 0, this.elementCount);
        this.elementCount = 0;
        this.buffer = null;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.elementCount; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(ToStringConverter.convert(this.buffer[i], "[NULL]"));
        }
        return builder.toString();
    }

    private E[] createBuffer(int initialCapacity) {
        return (Object[])Array.newInstance(this.componentType, initialCapacity);
    }
}

