/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ToStringFormat;
import org.databene.commons.converter.AnyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFormat
extends Format {
    private static final long serialVersionUID = 290320869220307493L;
    private static final String DEFAULT_SEPARATOR = ", ";
    private static final Format DEFAULT_ITEM_FORMAT = ToStringFormat.getDefault();
    private Format itemFormat;
    private String separator;

    public ArrayFormat() {
        this(DEFAULT_ITEM_FORMAT, DEFAULT_SEPARATOR);
    }

    public ArrayFormat(String separator) {
        this(DEFAULT_ITEM_FORMAT, separator);
    }

    public ArrayFormat(Format itemFormat) {
        this(itemFormat, DEFAULT_SEPARATOR);
    }

    public ArrayFormat(Format itemFormat, String separator) {
        this.itemFormat = itemFormat;
        this.separator = separator;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Object[] array = (Object[])obj;
        return ArrayFormat.formatPart(toAppendTo, this.itemFormat, this.separator, 0, array.length, array);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return ArrayFormat.parse(source, this.separator, String.class);
    }

    public static <T> String format(T ... items) {
        return ArrayFormat.format(DEFAULT_SEPARATOR, items);
    }

    public static <T> String format(String separator, T ... items) {
        if (items == null) {
            return "";
        }
        return ArrayFormat.formatPart(null, separator, 0, items.length, items);
    }

    public static <T> String format(Format format, String separator, T ... items) {
        return ArrayFormat.formatPart(format, separator, 0, items.length, items);
    }

    public static <T> String formatPart(int offset, int length, T ... items) {
        return ArrayFormat.formatPart(null, DEFAULT_SEPARATOR, offset, length, items);
    }

    public static <T> String formatPart(String separator, int offset, int length, T ... items) {
        return ArrayFormat.formatPart(null, separator, offset, length, items);
    }

    public static <T> String formatPart(Format format, String separator, int offset, int length, T ... items) {
        if (items.length == 0) {
            return "";
        }
        return ArrayFormat.formatPart(new StringBuilder(), format, separator, offset, length, items).toString();
    }

    public static <T, E extends Appendable> E formatPart(E toAppendTo, Format format, String separator, int offset, int length, T ... items) {
        if (items.length == 0) {
            return toAppendTo;
        }
        try {
            if (format == null) {
                format = ToStringFormat.getDefault();
            }
            toAppendTo.append(format.format(items[offset]));
            for (int i = 1; i < length; ++i) {
                toAppendTo.append(separator).append(format.format(items[offset + i]));
            }
            return toAppendTo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatInts(String separator, int ... items) {
        if (items.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            builder.append(separator).append(items[i]);
        }
        return builder.toString();
    }

    public static String formatBytes(String separator, byte ... items) {
        if (items.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            builder.append(separator).append(items[i]);
        }
        return builder.toString();
    }

    public static String formatChars(String separator, char ... items) {
        if (items.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            builder.append(separator).append(items[i]);
        }
        return builder.toString();
    }

    public static String formatStrings(String separator, String ... items) {
        if (items == null) {
            return "";
        }
        return ArrayFormat.formatPart(null, separator, 0, items.length, items);
    }

    public static <T> T[] parse(String source, String separator, Class<T> componentType) {
        int sepIndex;
        ArrayBuilder<T> builder = new ArrayBuilder<T>(componentType);
        int i = 0;
        while ((sepIndex = source.indexOf(separator, i)) >= 0) {
            String token = source.substring(i, sepIndex);
            builder.append(AnyConverter.convert(token, componentType));
            i = sepIndex + separator.length();
        }
        builder.append(AnyConverter.convert(source.substring(i, source.length()), componentType));
        return builder.toArray();
    }
}

