/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.NullSafeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtil {
    public static <T> T[] copyOfRange(T[] array, int offset, int length) {
        Class<?> resultType = array.getClass();
        Class<?> componentType = resultType.getComponentType();
        Object[] result = (Object[])Array.newInstance(componentType, length);
        System.arraycopy(array, offset, result, 0, length);
        return result;
    }

    public static <T> T[] remove(T[] array, int indexToRemove) {
        Class<?> resultType = array.getClass();
        Class<?> componentType = resultType.getComponentType();
        Object[] result = (Object[])Array.newInstance(componentType, array.length - 1);
        if (indexToRemove > 0) {
            System.arraycopy(array, 0, result, 0, indexToRemove);
        }
        System.arraycopy(array, indexToRemove + 1, result, indexToRemove, array.length - indexToRemove - 1);
        return result;
    }

    public static <T> boolean contains(T[] array, T element) {
        for (T o : array) {
            if (!NullSafeComparator.equals(o, element)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean endsWithSequence(T[] candidates, T[] searched) {
        if (searched.length > candidates.length) {
            return false;
        }
        for (int i = 0; i < searched.length; ++i) {
            if (candidates[candidates.length - searched.length + i].equals(searched[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] commonElements(T[] ... sources) {
        Class<?> componentType = null;
        for (int arrayNumber = 0; arrayNumber < sources.length && componentType == null; ++arrayNumber) {
            T[] source = sources[arrayNumber];
            for (int index = 0; index < source.length && componentType == null; ++index) {
                if (source[index] == null) continue;
                componentType = source[index].getClass();
            }
        }
        return ArrayUtil.commonElements(componentType, sources);
    }

    public static <T> T[] commonElements(Class<T> componentType, T[] ... sources) {
        T[] firstArray;
        ArrayBuilder<T> builder = new ArrayBuilder<T>(componentType);
        for (T element : firstArray = sources[0]) {
            boolean common = true;
            for (int i = 1; i < sources.length; ++i) {
                if (ArrayUtil.contains(sources[i], element)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            builder.append(element);
        }
        return builder.toArray();
    }

    public static <T> boolean equalsIgnoreOrder(T[] a1, T[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        ArrayList<T> l1 = new ArrayList<T>(a1.length);
        for (T item : a1) {
            l1.add(item);
        }
        for (int i = a1.length - 1; i >= 0; --i) {
            if (!ArrayUtil.contains(a2, a1[i])) {
                return false;
            }
            l1.remove(i);
        }
        return l1.size() == 0;
    }

    public static <T> int indexOf(T searchedItem, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            T candidate = array[i];
            if (!NullSafeComparator.equals(candidate, searchedItem)) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] toArray(T ... values) {
        Class<Object> componentType = values.length > 0 ? values[0].getClass() : Object.class;
        return ArrayUtil.buildArrayOfType(componentType, values);
    }

    public static <T> T[] buildArrayOfType(Class<T> componentType, T ... values) {
        Object[] array = (Object[])Array.newInstance(componentType, values.length);
        System.arraycopy(values, 0, array, 0, values.length);
        return array;
    }

    public static <T> T[] revert(T[] array) {
        for (int i = (array.length >> 1) - 1; i >= 0; --i) {
            T tmp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = tmp;
        }
        return array;
    }

    public static char[] revert(char[] array) {
        for (int i = (array.length >> 1) - 1; i >= 0; --i) {
            char tmp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = tmp;
        }
        return array;
    }

    public static <T> Class<T[]> arrayType(Class<T> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, 0);
        return array.getClass();
    }

    public static <T> T[] newInstance(Class<T> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <T> T[] append(T[] array, T value) {
        if (array == null) {
            return ArrayUtil.toArray(value);
        }
        Class<?> componentType = array.getClass().getComponentType();
        ?[] newArray = ArrayUtil.newInstance(componentType, array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static boolean isEmpty(Object[] values) {
        return values == null || values.length == 0;
    }

    @Deprecated
    public static boolean equals(Object[] a1, Object[] a2) {
        return Arrays.deepEquals(a1, a2);
    }

    public static <T> T lastElement(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return null;
        }
        return array[array.length - 1];
    }
}

