/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.Arrays;
import org.databene.commons.ArrayFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assert {
    private Assert() {
    }

    public void end(String text, String end) {
        if (text == null) {
            if (end != null) {
                throw new AssertionError((Object)("String is supposed to end with '" + end + ", but is null."));
            }
        } else if (!text.endsWith(end)) {
            throw new AssertionError((Object)("String is supposed to end with '" + end + ", but is: " + text));
        }
    }

    public static void endIgnoreCase(String text, String end) {
        if (text == null) {
            if (end != null) {
                throw new AssertionError((Object)("String is supposed to end with '" + end + ", but is null."));
            }
        } else if (!text.endsWith(end)) {
            throw new AssertionError((Object)("String is supposed to case-insensitively end with '" + end + ", but is: " + text));
        }
    }

    public static <T> T notNull(T object, String objectRole) {
        if (object == null) {
            throw new AssertionError((Object)(objectRole + " is not supposed to be null"));
        }
        return object;
    }

    public static void notEmpty(String text, String message) {
        if (text == null || text.length() == 0) {
            throw new AssertionError((Object)message);
        }
    }

    public static <T> void equals(T[] a1, T[] a2) {
        if (a1 == null && a2 == null) {
            return;
        }
        if (a1 == null && a2 != null || a1 != null && a2 == null) {
            throw new AssertionError((Object)"Arrays are not equal, one of them is null");
        }
        if (a1.length != a2.length) {
            throw new AssertionError((Object)("Arrays are not equal, the size differs: [" + ArrayFormat.format(a1) + "] vs. [" + ArrayFormat.format(a2) + ']'));
        }
        if (!Arrays.deepEquals(a1, a2)) {
            throw new AssertionError((Object)("Arrays are not equal, content differs: [" + ArrayFormat.format(a1) + "] vs. [" + ArrayFormat.format(a2) + ']'));
        }
    }

    public static void equals(byte[] a1, byte[] a2) {
        if (a1 == null && a2 == null) {
            return;
        }
        if (a1 == null && a2 != null || a1 != null && a2 == null) {
            throw new AssertionError((Object)"Arrays are not equal, one of them is null");
        }
        if (a1.length != a2.length) {
            throw new AssertionError((Object)("Arrays are not equal, the size differs: [" + ArrayFormat.formatBytes(",", a1) + "] vs. [" + ArrayFormat.formatBytes(",", a2) + ']'));
        }
        if (!Arrays.equals(a1, a2)) {
            throw new AssertionError((Object)("Arrays are not equal, content differs: [" + ArrayFormat.formatBytes(",", a1) + "] vs. [" + ArrayFormat.formatBytes(",", a2) + ']'));
        }
    }

    public static void length(String string, int length) {
        if (string == null || string.length() != length) {
            throw new AssertionError((Object)("Unexpected string length: Expected " + length + ", found: " + string.length()));
        }
    }

    public static void instanceOf(Object object, Class type, String name) {
        if (object == null) {
            throw new AssertionError((Object)(name + " is not supposed to be null"));
        }
        if (!type.isAssignableFrom(object.getClass())) {
            throw new AssertionError((Object)(name + " is expected to be of type " + type.getName() + ", but is " + object.getClass()));
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new AssertionError((Object)message);
        }
    }

    public static void found(Object object, String name) {
        if (object == null) {
            throw new AssertionError((Object)(name + " not found"));
        }
    }
}

