/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.Arrays;

public class Base64Codec {
    private static final char[] DIGITS = Base64Codec.createDigits();
    private static final byte[] INDICES = Base64Codec.createIndices();

    private Base64Codec() {
    }

    public static String encode(byte[] source) {
        int srcLength = source.length;
        int srcCursor = 0;
        int unpaddedLength = (srcLength * 4 + 2) / 3;
        int paddedLength = (srcLength + 2) / 3 * 4;
        char[] buffer = new char[paddedLength];
        int bufferCursor = 0;
        while (srcCursor < srcLength) {
            int d0 = source[srcCursor++] & 0xFF;
            int d1 = srcCursor < srcLength ? source[srcCursor++] & 0xFF : 0;
            int d2 = srcCursor < srcLength ? source[srcCursor++] & 0xFF : 0;
            buffer[bufferCursor++] = DIGITS[d0 >>> 2];
            buffer[bufferCursor++] = DIGITS[(d0 & 3) << 4 | d1 >>> 4];
            buffer[bufferCursor] = bufferCursor++ < unpaddedLength ? DIGITS[(d1 & 0xF) << 2 | d2 >>> 6] : 61;
            buffer[bufferCursor] = bufferCursor++ < unpaddedLength ? DIGITS[d2 & 0x3F] : 61;
        }
        return new String(buffer);
    }

    public static byte[] decode(String code) {
        if (code == null) {
            throw new IllegalArgumentException("code is null");
        }
        char[] codeBuffer = code.toCharArray();
        int codeLength = codeBuffer.length;
        if (codeLength % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (codeLength > 0 && codeBuffer[codeLength - 1] == '=') {
            --codeLength;
        }
        for (int i = 0; i < codeLength; ++i) {
            if (Base64Codec.isBase64Char(codeBuffer[i])) continue;
            throw new IllegalArgumentException("Not a base64 code: " + code);
        }
        int resultLength = codeLength * 3 / 4;
        byte[] result = new byte[resultLength];
        int codeCursor = 0;
        int resultCursor = 0;
        while (codeCursor < codeLength) {
            byte b0 = INDICES[codeBuffer[codeCursor++]];
            byte b1 = INDICES[codeBuffer[codeCursor++]];
            byte b2 = codeCursor < codeLength ? INDICES[codeBuffer[codeCursor++]] : (byte)0;
            byte b3 = codeCursor < codeLength ? INDICES[codeBuffer[codeCursor++]] : (byte)0;
            result[resultCursor++] = (byte)(b0 << 2 | b1 >>> 4);
            if (resultCursor < resultLength) {
                result[resultCursor++] = (byte)((b1 & 0xF) << 4 | b2 >>> 2);
            }
            if (resultCursor >= resultLength) continue;
            result[resultCursor++] = (byte)((b2 & 3) << 6 | b3);
        }
        return result;
    }

    public static boolean isBase64Char(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '+' || c == '/';
    }

    private static char[] createDigits() {
        int c;
        char[] digits = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            digits[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            digits[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            digits[i++] = c;
        }
        digits[i++] = 43;
        digits[i++] = 47;
        return digits;
    }

    private static byte[] createIndices() {
        byte[] indices = new byte[128];
        Arrays.fill(indices, 0, indices.length, (byte)-1);
        for (int i = 0; i < 64; ++i) {
            indices[Base64Codec.DIGITS[i]] = (byte)i;
        }
        return indices;
    }
}

