/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Escalator;
import org.databene.commons.ExceptionMapper;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.ArrayTypeConverter;
import org.databene.commons.converter.ToStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanUtil {
    private static final Log logger = LogFactory.getLog(BeanUtil.class);
    private static Escalator escalator = new LoggerEscalator();
    private static final Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private static final Class<?>[] simpleTypes = new Class[]{String.class, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class};
    private static final PrimitiveTypeMapping[] primitiveNumberTypes = new PrimitiveTypeMapping[]{new PrimitiveTypeMapping(Long.TYPE, Long.class), new PrimitiveTypeMapping(Integer.TYPE, Integer.class), new PrimitiveTypeMapping(Short.TYPE, Short.class), new PrimitiveTypeMapping(Byte.TYPE, Byte.class), new PrimitiveTypeMapping(Float.TYPE, Float.class), new PrimitiveTypeMapping(Double.TYPE, Double.class)};
    private static final PrimitiveTypeMapping[] primitiveNonNumberTypes = new PrimitiveTypeMapping[]{new PrimitiveTypeMapping(Boolean.TYPE, Boolean.class), new PrimitiveTypeMapping(Character.TYPE, Character.class)};
    private static Map<String, Class<? extends Object>> simpleTypeMap = new HashMap<String, Class<? extends Object>>();
    private static Map<String, Class<? extends Object>> primitiveTypeMap;
    private static Map<String, Class<? extends Object>> primitiveNumberTypeMap;

    private BeanUtil() {
    }

    public static boolean isSimpleType(String className) {
        return simpleTypeMap.containsKey(className);
    }

    public static boolean isPrimitive(String className) {
        return primitiveTypeMap.containsKey(className);
    }

    public static boolean isPrimitiveNumber(String className) {
        return primitiveNumberTypeMap.containsKey(className);
    }

    public static Class<? extends Object> getWrapper(String primitiveClassName) {
        return primitiveTypeMap.get(primitiveClassName);
    }

    public static boolean isCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    public static Object getAttributeValue(Object obj, String attributeName) {
        if (obj == null) {
            throw new IllegalArgumentException("Object may not be null");
        }
        Field field = BeanUtil.getField(obj.getClass(), attributeName);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, field);
        }
    }

    public static void setAttributeValue(Object obj, String fieldName, Object value) {
        Field field = BeanUtil.getField(obj.getClass(), fieldName);
        BeanUtil.setAttributeValue(obj, field, value);
    }

    public static Object getStaticAttributeValue(Class<? extends Object> objectType, String attributeName) {
        Field field = BeanUtil.getField(objectType, attributeName);
        try {
            return field.get(null);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, field);
        }
    }

    public static void setStaticAttributeValue(Class<? extends Object> objectType, String fieldName, Object value) {
        Field field = BeanUtil.getField(objectType, fieldName);
        BeanUtil.setAttributeValue(null, field, value);
    }

    private static void setAttributeValue(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, field);
        }
    }

    public static Class<? extends Object>[] getGenericTypes(Field field) {
        Type genericFieldType = field.getGenericType();
        if (!(genericFieldType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pType = (ParameterizedType)genericFieldType;
        Type[] args = pType.getActualTypeArguments();
        Class[] types = new Class[args.length];
        System.arraycopy(args, 0, types, 0, args.length);
        return types;
    }

    public static <T> Class<T> forName(String name) {
        Class<? extends Object> type = simpleTypeMap.get(name);
        if (type != null) {
            return type;
        }
        try {
            return BeanUtil.getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionMapper.configurationException((Exception)e, name);
        }
    }

    public static ClassLoader getContextClassLoader() {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (result == null) {
            result = BeanUtil.class.getClassLoader();
        }
        return result;
    }

    public static Object newInstance(String className) {
        Class type = BeanUtil.forName(className);
        return BeanUtil.newInstanceFromDefaultConstructor(type);
    }

    public static <T> T newInstance(Class<T> type, Object ... parameters) {
        return BeanUtil.newInstance(type, true, parameters);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T newInstance(Class<T> type, boolean strict, Object ... parameters) {
        if (parameters.length == 0) {
            return BeanUtil.newInstanceFromDefaultConstructor(type);
        }
        Constructor<?> constructorToUse = null;
        try {
            void var9_13;
            Constructor<?>[] constructors = type.getConstructors();
            ArrayList candidates = new ArrayList(constructors.length);
            int paramCount = parameters.length;
            Constructor<?>[] arr$ = constructors;
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_13 < len$) {
                Constructor<?> constructor = arr$[var9_13];
                if (constructor.getParameterTypes().length == paramCount) {
                    candidates.add(constructor);
                }
                ++var9_13;
            }
            if (candidates.size() == 1) {
                constructorToUse = (Constructor<?>)candidates.get(0);
            } else {
                if (candidates.size() == 0) {
                    throw new ConfigurationError("No constructor with " + paramCount + " parameters found for " + type);
                }
                Class[] paramTypes = new Class[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    paramTypes[i] = parameters[i].getClass();
                }
                for (Constructor<?> c : type.getConstructors()) {
                    if (!BeanUtil.typesMatch(c.getParameterTypes(), paramTypes)) continue;
                    constructorToUse = c;
                    break;
                }
                if (constructorToUse == null) {
                    if (strict) {
                        throw new NoSuchMethodException("No appropriate constructor found: " + type + '(' + ArrayFormat.format(", ", paramTypes) + ')');
                    }
                    for (Constructor constructor : candidates) {
                        try {
                            return (T)BeanUtil.newInstance(constructorToUse, strict, parameters);
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Exception in constructor call: " + constructor), (Throwable)e);
                        }
                    }
                    throw new ConfigurationError("None of these constructors could be called without exception: " + candidates);
                }
            }
            if (!strict) {
                parameters = BeanUtil.convertArray(parameters, constructorToUse.getParameterTypes());
            }
            return BeanUtil.newInstance(constructorToUse, parameters);
        }
        catch (SecurityException e) {
            throw ExceptionMapper.configurationException((Exception)e, constructorToUse);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionMapper.configurationException((Exception)e, type);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... params) {
        return BeanUtil.newInstance(constructor, true, params);
    }

    public static <T> T newInstance(Constructor<T> constructor, boolean strict, Object ... parameters) {
        Class<T> type;
        if (!strict) {
            parameters = BeanUtil.convertArray(parameters, constructor.getParameterTypes());
        }
        if (BeanUtil.deprecated(type = constructor.getDeclaringClass())) {
            escalator.escalate("Instantiating a deprecated class: " + type.getName(), BeanUtil.class, null);
        }
        try {
            return constructor.newInstance(parameters);
        }
        catch (InstantiationException e) {
            throw ExceptionMapper.configurationException((Exception)e, type);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, type);
        }
        catch (InvocationTargetException e) {
            throw ExceptionMapper.configurationException((Exception)e, type);
        }
    }

    public static Method getMethod(Class<? extends Object> type, String methodName, Class<? extends Object> ... paramTypes) {
        Method method = BeanUtil.findMethod(type, methodName, paramTypes);
        if (method == null) {
            throw new ConfigurationError("method not found: " + methodName + '(' + ArrayFormat.format(paramTypes) + ')');
        }
        return method;
    }

    public static Method findMethod(Class<? extends Object> type, String methodName, Class<? extends Object> ... paramTypes) {
        Method[] methods;
        for (Method method : methods = type.getMethods()) {
            if (!methodName.equals(method.getName()) || !BeanUtil.typesMatch(paramTypes, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public static Method[] findMethodsByName(Class<? extends Object> type, String methodName) {
        ArrayBuilder<Method> builder = new ArrayBuilder<Method>(Method.class);
        for (Method method : type.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            builder.append(method);
        }
        return builder.toArray();
    }

    public static Object invoke(Object target, String methodName, Object ... args) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        Class[] argTypes = null;
        if (args != null) {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] != null ? args[i].getClass() : null;
            }
        }
        Method method = BeanUtil.getMethod(target.getClass(), methodName, argTypes);
        return BeanUtil.invoke(target, method, args);
    }

    public static <T> T invokeStatic(Class<? extends Object> targetClass, String methodName, Object ... args) {
        if (targetClass == null) {
            throw new IllegalArgumentException("target is null");
        }
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = args[i] != null ? args[i].getClass() : null;
        }
        Method method = BeanUtil.getMethod(targetClass, methodName, argClasses);
        return (T)BeanUtil.invoke(null, method, args);
    }

    public static Object invoke(Object target, Method method, Object ... args) {
        return BeanUtil.invoke(target, method, true, args);
    }

    public static <T> T invoke(Object target, Method method, boolean strict, Object ... args) {
        try {
            Object[] params = strict ? args : ArrayTypeConverter.convert(args, method.getParameterTypes());
            return (T)method.invoke(target, params);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, method);
        }
        catch (InvocationTargetException e) {
            throw ExceptionMapper.configurationException((Exception)e, method);
        }
    }

    public static boolean typesMatch(Class<? extends Object>[] foundTypes, Class<? extends Object>[] expectedTypes) {
        if (foundTypes == null) {
            return expectedTypes == null || expectedTypes.length == 0;
        }
        if (foundTypes.length != expectedTypes.length) {
            return false;
        }
        if (expectedTypes.length == 0) {
            return true;
        }
        for (int i = 0; i < foundTypes.length; ++i) {
            Class<? extends Object> expectedType = expectedTypes[i];
            Class<? extends Object> foundType = foundTypes[i];
            if (expectedType.isAssignableFrom(foundType)) {
                return true;
            }
            if (BeanUtil.isPrimitive(expectedType.getName()) && foundType.equals(BeanUtil.getWrapper(expectedType.getName()))) {
                return true;
            }
            if (!BeanUtil.isPrimitive(foundType.getName()) || !expectedType.equals(BeanUtil.getWrapper(foundType.getName()))) continue;
            return true;
        }
        return false;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<? extends Object> beanClass, String propertyName) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass is null");
        }
        String propertyId = beanClass.getName() + '#' + propertyName;
        PropertyDescriptor result = propertyDescriptors.get(propertyId);
        if (result != null) {
            return result;
        }
        int separatorIndex = propertyName.indexOf(46);
        if (separatorIndex >= 0) {
            String localProperty = propertyName.substring(0, separatorIndex);
            String remoteProperty = propertyName.substring(separatorIndex + 1);
            Class<?> localPropertyType = BeanUtil.getPropertyDescriptor(beanClass, localProperty).getPropertyType();
            result = BeanUtil.getPropertyDescriptor(localPropertyType, remoteProperty);
        } else {
            try {
                PropertyDescriptor[] descriptors;
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
                    String name = descriptor.getName();
                    if (!name.equals(propertyName)) continue;
                    result = descriptor;
                    break;
                }
            }
            catch (IntrospectionException e) {
                throw ExceptionMapper.configurationException((Exception)e, propertyName);
            }
        }
        propertyDescriptors.put(propertyId, result);
        return result;
    }

    public static boolean hasProperty(Class<? extends Object> beanClass, String propertyName) {
        return BeanUtil.getPropertyDescriptor(beanClass, propertyName) != null;
    }

    public static String readMethodName(String propertyName, Class<? extends Object> propertyType) {
        if (Boolean.TYPE.equals(propertyType) || Boolean.class.equals(propertyType)) {
            return "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        }
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static String writeMethodName(String propertyName) {
        return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<? extends Object> type) {
        try {
            return Introspector.getBeanInfo(type).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getPropertyValue(Object bean, String propertyName) {
        return BeanUtil.getPropertyValue(bean, propertyName, true);
    }

    public static Object getPropertyValue(Object bean, String propertyName, boolean strict) {
        Method readMethod = null;
        try {
            PropertyDescriptor descriptor = BeanUtil.getPropertyDescriptor(bean.getClass(), propertyName);
            if (descriptor == null && strict) {
                throw new ConfigurationError("Property '" + propertyName + "' not found in class " + bean.getClass());
            }
            readMethod = descriptor.getReadMethod();
            return readMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, readMethod);
        }
        catch (InvocationTargetException e) {
            throw ExceptionMapper.configurationException((Exception)e, readMethod);
        }
    }

    public static void setPropertyValue(Object bean, String propertyName, Object propertyValue) {
        BeanUtil.setPropertyValue(bean, propertyName, propertyValue, true);
    }

    public static void setPropertyValue(Object bean, String propertyName, Object propertyValue, boolean strict) {
        BeanUtil.setPropertyValue(bean, propertyName, propertyValue, strict, !strict);
    }

    public static void setPropertyValue(Object bean, String propertyName, Object argument, boolean required, boolean autoConvert) {
        Method writeMethod = null;
        try {
            Class<?> beanClass = bean.getClass();
            PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(beanClass, propertyName);
            if (propertyDescriptor == null) {
                if (required) {
                    throw new ConfigurationError(beanClass + " does not have a property '" + propertyName + "'");
                }
                return;
            }
            writeMethod = propertyDescriptor.getWriteMethod();
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            if (argument != null) {
                Class<?> argType = argument.getClass();
                if (!(propertyType.isAssignableFrom(argType) || BeanUtil.isWrapperTypeOf(propertyType, argument) || autoConvert)) {
                    throw new IllegalArgumentException("ArgumentType mismatch: expected " + propertyType.getName() + ", found " + argument.getClass().getName());
                }
                argument = AnyConverter.convert(argument, propertyType);
            }
            writeMethod.invoke(bean, argument);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, writeMethod);
        }
        catch (InvocationTargetException e) {
            throw ExceptionMapper.configurationException((Exception)e, writeMethod);
        }
    }

    private static boolean isWrapperTypeOf(Class<?> propertyType, Object propertyValue) {
        String propertyTypeName = propertyType.getName();
        return BeanUtil.isPrimitive(propertyTypeName) && BeanUtil.getWrapper(propertyType.getName()) == propertyValue.getClass();
    }

    public static <BEAN, PROP_TYPE> List<PROP_TYPE> extractProperties(Collection<BEAN> beans, String propertyName) {
        ArrayList<Object> result = new ArrayList<Object>(beans.size());
        for (BEAN bean : beans) {
            result.add(BeanUtil.getPropertyValue(bean, propertyName));
        }
        return result;
    }

    public static void printClassInfo(Object object, PrintWriter printer) {
        if (object == null) {
            printer.println("null");
            return;
        }
        Class<?> type = object.getClass();
        printer.println(type);
        if (type.getSuperclass() != null) {
            printer.println("extends " + type.getSuperclass());
        }
        for (Class<?> clazz : type.getInterfaces()) {
            printer.println("implements " + clazz);
        }
        for (GenericDeclaration genericDeclaration : type.getMethods()) {
            printer.println(genericDeclaration);
        }
    }

    public static void checkJavaBean(Class<? extends Object> cls) {
        try {
            Constructor<? extends Object> constructor = cls.getDeclaredConstructor(new Class[0]);
            int classModifiers = cls.getModifiers();
            if (Modifier.isInterface(classModifiers)) {
                throw new RuntimeException(cls.getName() + " is an interface");
            }
            if (Modifier.isAbstract(classModifiers)) {
                throw new RuntimeException(cls.getName() + " cannot be instantiated - it is an abstract class");
            }
            int modifiers = constructor.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new RuntimeException("No public default constructor in " + cls);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in class " + cls);
        }
        catch (SecurityException e) {
            logger.error((Object)"I am not allowed to check the class by using reflection, so I just can hope the class is alright and go on: ", (Throwable)e);
        }
    }

    public static boolean deprecated(Class<? extends Object> type) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = type.getDeclaredAnnotations()) {
            if (!(annotation instanceof Deprecated)) continue;
            return true;
        }
        return false;
    }

    private static <T> T newInstanceFromDefaultConstructor(Class<T> type) {
        if (type == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Instantiating " + type.getSimpleName()));
        }
        if (BeanUtil.deprecated(type)) {
            escalator.escalate("Instantiating a deprecated class: " + type.getName(), BeanUtil.class, null);
        }
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw ExceptionMapper.configurationException((Exception)e, type);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, type);
        }
    }

    private static Field getField(Class<? extends Object> type, String name) {
        try {
            return type.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw ExceptionMapper.configurationException((Exception)e, type.getName() + '.' + name);
        }
    }

    public static Method[] findMethodsByAnnotation(Class<? extends Object> owner, Class<? extends Annotation> annotationClass) {
        Method[] methods = owner.getMethods();
        ArrayBuilder<Method> builder = new ArrayBuilder<Method>(Method.class);
        for (Method method : methods) {
            if (method.getAnnotation(annotationClass) == null) continue;
            builder.append(method);
        }
        return builder.toArray();
    }

    public static <C, I> Type[] getGenericInterfaceParams(Class<C> checkedClass, Class<I> searchedInterface) {
        for (Type type : checkedClass.getGenericInterfaces()) {
            ParameterizedType pt = (ParameterizedType)type;
            if (!searchedInterface.equals(pt.getRawType())) continue;
            ParameterizedType pType = (ParameterizedType)type;
            return pType.getActualTypeArguments();
        }
        if (!Object.class.equals(checkedClass.getSuperclass())) {
            return BeanUtil.getGenericInterfaceParams(checkedClass.getSuperclass(), searchedInterface);
        }
        throw new ConfigurationError(checkedClass + " does not implement interface with generic parameters: " + searchedInterface);
    }

    public static String toString(Object bean) {
        if (bean == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(bean.getClass().getName());
        PropertyDescriptor[] descriptors = BeanUtil.getPropertyDescriptors(bean.getClass());
        boolean first = true;
        for (PropertyDescriptor descriptor : descriptors) {
            String propertyName = descriptor.getName();
            if ("class".equals(propertyName)) continue;
            if (first) {
                builder.append('[');
            } else {
                builder.append(", ");
            }
            Object value = BeanUtil.getPropertyValue(bean, propertyName);
            String valueString = ToStringConverter.convert(value, "null");
            builder.append(propertyName).append("=").append(valueString);
            first = false;
        }
        if (!first) {
            builder.append(']');
        }
        return builder.toString();
    }

    public static String simpleName(Class type) {
        return type != null ? type.getSimpleName() : null;
    }

    private static Object[] convertArray(Object[] values, Class<?>[] targetTypes) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = AnyConverter.convert(values[i], targetTypes[i]);
        }
        return result;
    }

    static {
        for (Class<?> clazz : simpleTypes) {
            simpleTypeMap.put(clazz.getName(), clazz);
        }
        primitiveNumberTypeMap = new HashMap<String, Class<? extends Object>>();
        primitiveTypeMap = new HashMap<String, Class<? extends Object>>();
        for (PrimitiveTypeMapping primitiveTypeMapping : primitiveNumberTypes) {
            primitiveNumberTypeMap.put(primitiveTypeMapping.primitiveType.getName(), primitiveTypeMapping.wrapperType);
            primitiveTypeMap.put(primitiveTypeMapping.primitiveType.getName(), primitiveTypeMapping.wrapperType);
        }
        for (PrimitiveTypeMapping primitiveTypeMapping : primitiveNonNumberTypes) {
            primitiveTypeMap.put(primitiveTypeMapping.primitiveType.getName(), primitiveTypeMapping.wrapperType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrimitiveTypeMapping {
        public Class<? extends Object> primitiveType;
        public Class<? extends Object> wrapperType;

        public PrimitiveTypeMapping(Class<? extends Object> primitiveType, Class<? extends Object> wrapperType) {
            this.primitiveType = primitiveType;
            this.wrapperType = wrapperType;
        }
    }
}

