/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.databene.commons.LocaleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharSet {
    private Locale locale;
    private Set<Character> set;

    public CharSet() {
        this(LocaleUtil.getFallbackLocale());
    }

    public CharSet(Locale locale) {
        this.set = new HashSet<Character>();
        this.locale = locale;
    }

    public CharSet(char c) {
        this.set = new HashSet<Character>();
        this.set.add(Character.valueOf(c));
        this.locale = LocaleUtil.getFallbackLocale();
    }

    public CharSet(char from, char to) {
        this.set = new HashSet<Character>();
        for (char c = from; c <= to; c = (char)(c + '\u0001')) {
            this.set.add(Character.valueOf(c));
        }
        this.locale = LocaleUtil.getFallbackLocale();
    }

    public CharSet(Set<Character> set) {
        this.set = new HashSet<Character>(set);
        this.locale = LocaleUtil.getFallbackLocale();
    }

    public CharSet addDigits() {
        return this.add(CharSet.getDigits());
    }

    public CharSet removeDigits() {
        return this.remove(CharSet.getDigits());
    }

    public CharSet addHexDigits() {
        return this.add(CharSet.getHexDigits());
    }

    public CharSet removeHexDigits() {
        return this.remove(CharSet.getHexDigits());
    }

    public CharSet addNonDigits() {
        return this.add(CharSet.getNonDigits());
    }

    public CharSet removeNonDigits() {
        return this.remove(CharSet.getNonDigits());
    }

    public static Set<Character> getDigits() {
        return new CharSet('0', '9').getSet();
    }

    public static Set<Character> getHexDigits() {
        return new CharSet('0', '9').addRange('a', 'f').addRange('A', 'F').getSet();
    }

    public static Set<Character> getNonDigits() {
        return new CharSet().addAnyCharacters().remove(CharSet.getDigits()).getSet();
    }

    public CharSet addWordChars() {
        return this.addWordChars(this.locale);
    }

    public CharSet addWordChars(Locale locale) {
        return this.add(CharSet.getWordChars(locale));
    }

    public CharSet removeWordChars() {
        return this.removeWordChars(this.locale);
    }

    public CharSet removeWordChars(Locale locale) {
        return this.remove(CharSet.getWordChars(locale));
    }

    public static Set<Character> getWordChars(Locale locale) {
        Set<Character> wordChars = LocaleUtil.letters(locale);
        wordChars.add(Character.valueOf('_'));
        wordChars.addAll(CharSet.getDigits());
        return wordChars;
    }

    public CharSet addNonWordChars() {
        return this.add(CharSet.getNonWordChars());
    }

    public CharSet removeNonWordChars() {
        return this.remove(CharSet.getNonWordChars());
    }

    public static Set<Character> getNonWordChars() {
        return new CharSet(' ', '@').addRange('[', '`').addRange('{', '~').getSet();
    }

    public CharSet addWhitespaces() {
        return this.add(CharSet.getWhitespaces());
    }

    public CharSet removeWhitespaces() {
        return this.remove(CharSet.getWhitespaces());
    }

    public static Set<Character> getWhitespaces() {
        return new CharSet().add(' ').add('\t').add('\n').add('\u000b').add('\f').add('\r').getSet();
    }

    public CharSet addNonWhitespaces() {
        return this.add(CharSet.getNonWhitespaces());
    }

    public CharSet removeNonWhitespaces() {
        return this.remove(CharSet.getNonWhitespaces());
    }

    public static Set<Character> getNonWhitespaces() {
        return new CharSet().addAnyCharacters().remove(CharSet.getWhitespaces()).getSet();
    }

    public CharSet addAnyCharacters() {
        return this.add(CharSet.getAnyCharacters());
    }

    public static Set<Character> getAnyCharacters() {
        HashSet<Character> set = new HashSet<Character>();
        for (int c = 32; c < 127; ++c) {
            set.add(Character.valueOf((char)c));
        }
        return set;
    }

    public CharSet removeAll() {
        this.set.clear();
        return this;
    }

    public CharSet addRange(char from, char to) {
        for (char c = from; c <= to; c = (char)(c + '\u0001')) {
            this.set.add(Character.valueOf(c));
        }
        return this;
    }

    public CharSet add(char c) {
        this.set.add(Character.valueOf(c));
        return this;
    }

    public CharSet add(Set<Character> chars) {
        this.set.addAll(chars);
        return this;
    }

    public CharSet remove(Set<Character> chars) {
        this.set.removeAll(chars);
        return this;
    }

    public CharSet removeRange(char min, char max) {
        for (char c = min; c <= max; c = (char)(c + '\u0001')) {
            this.remove(c);
        }
        return this;
    }

    public CharSet remove(char c) {
        if (this.set.contains(Character.valueOf(c))) {
            this.set.remove(Character.valueOf(c));
        }
        return this;
    }

    public Set<Character> getSet() {
        return new HashSet<Character>(this.set);
    }

    public boolean contains(char c) {
        return this.set.contains(Character.valueOf(c));
    }

    public int size() {
        return this.set.size();
    }

    public String toString() {
        return this.set.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharSet charSet = (CharSet)o;
        return ((Object)this.set).equals(charSet.set);
    }

    public int hashCode() {
        return ((Object)this.set).hashCode();
    }
}

