/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.databene.commons.BeanUtil;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.OrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CollectionUtil {
    public static boolean isEmpty(Collection<? extends Object> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <T> List<T> toList(T ... array) {
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (T item : array) {
            result.add(item);
        }
        return result;
    }

    public static <T, S> List<T> toListOfType(S ... array) {
        ArrayList<S> result = new ArrayList<S>(array.length);
        for (int i = 0; i < array.length; ++i) {
            S item = array[i];
            result.add(item);
        }
        return result;
    }

    public static <T> Set<T> toSet(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <T, U extends T> SortedSet<T> toSortedSet(U ... elements) {
        TreeSet<U> set = new TreeSet<U>();
        for (U element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <T, U extends T, C extends Collection<? super T>> C add(C target, U ... values) {
        for (U item : values) {
            target.add(item);
        }
        return target;
    }

    public static <T> List<T> copy(List<? extends T> src, int offset, int length) {
        ArrayList<T> items = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            items.add(src.get(offset + i));
        }
        return items;
    }

    public static <T, U> T[] toArray(Collection<? extends T> source) {
        if (source.size() == 0) {
            throw new IllegalArgumentException("For empty collections, a componentType needs to be specified.");
        }
        Class<?> componentType = source.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(componentType, source.size());
        return source.toArray(array);
    }

    public static <T> T[] toArray(Collection<? extends T> source, Class<T> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, source.size());
        return source.toArray(array);
    }

    public static char[] toArray(Collection<Character> source) {
        char[] result = new char[source.size()];
        int i = 0;
        for (Character c : source) {
            result[i++] = c.charValue();
        }
        return result;
    }

    public static Map buildMap(Object ... keyValuePairs) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid numer of arguments. It must be even to represent key-value-pairs");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            map.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return map;
    }

    public static Map buildOrderedMap(Object ... keyValuePairs) {
        OrderedMap<Object, Object> map = new OrderedMap<Object, Object>();
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid numer of arguments. It must be even to represent key-value-pairs");
        }
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            map.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return map;
    }

    public static <T extends Collection> T newInstance(Class<T> collectionType) {
        if ((collectionType.getModifiers() & 0x400) == 0) {
            return (T)((Collection)BeanUtil.newInstance(collectionType, new Object[0]));
        }
        if (collectionType == Collection.class || collectionType == List.class) {
            return (T)new ArrayList();
        }
        if (collectionType == SortedSet.class) {
            return (T)new TreeSet();
        }
        if (collectionType == Set.class) {
            return (T)new TreeSet();
        }
        throw new UnsupportedOperationException("Not a supported collection type: " + collectionType.getName());
    }

    public static <T> boolean equalsIgnoreOrder(List<T> a1, List<T> a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null) {
            return false;
        }
        if (a1.size() != a2.size()) {
            return false;
        }
        ArrayList<T> l1 = new ArrayList<T>(a1.size());
        for (T item : a1) {
            l1.add(item);
        }
        for (int i = a1.size() - 1; i >= 0; --i) {
            if (!a2.contains(a1.get(i))) {
                return false;
            }
            l1.remove(i);
        }
        return l1.size() == 0;
    }

    public static <V> V getCaseInsensitive(String key, Map<String, V> map) {
        V result = map.get(key);
        if (result != null || key == null) {
            return result;
        }
        String lcKey = key.toLowerCase();
        for (String candidate : map.keySet()) {
            if (candidate == null || !lcKey.equals(candidate.toLowerCase())) continue;
            return map.get(candidate);
        }
        return null;
    }

    public static <T> boolean ofEqualContent(List<T> list, T[] array) {
        if (list == null || list.isEmpty()) {
            return array == null || array.length == 0;
        }
        if (array == null || list.size() != array.length) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (NullSafeComparator.equals(list.get(i), array[i])) continue;
            return false;
        }
        return true;
    }
}

