/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.databene.commons.Composite;
import org.databene.commons.SystemInfo;
import org.databene.commons.TimeUtil;
import org.databene.commons.converter.ToStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFormatter {
    private static final String DEFAULT_TIMESTAMP_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String INDENT_DELTA = "    ";
    boolean flat;
    boolean renderNames;
    private String datePattern;
    private String timestampPattern;
    private String nullValue;

    public CompositeFormatter() {
        this(true, true);
    }

    public CompositeFormatter(boolean flat, boolean renderNames) {
        this(flat, renderNames, DEFAULT_DATE_PATTERN, DEFAULT_TIMESTAMP_PATTERN);
    }

    public CompositeFormatter(boolean flat, boolean renderNames, String datePattern, String timestampPattern) {
        this.flat = flat;
        this.renderNames = renderNames;
        this.datePattern = datePattern;
        this.timestampPattern = timestampPattern;
        this.nullValue = "[null]";
    }

    public <T> String render(String head, Composite<T> composite, String tail) {
        if (this.flat) {
            return this.renderFlat(head, composite, tail);
        }
        return this.renderHierarchical(head, composite, tail);
    }

    public <T> String renderHierarchical(String head, Composite<T> composite, String tail, String indent) {
        return head + this.renderComponentsHierarchical(composite, indent) + tail;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    private <T> String renderFlat(String head, Composite<T> composite, String tail) {
        return head + this.renderComponentsFlat(composite) + tail;
    }

    private <T> String renderHierarchical(String head, Composite<T> composite, String tail) {
        return this.renderHierarchical(head, composite, tail, "");
    }

    private <T> String renderComponentsFlat(Composite<T> composite) {
        StringBuilder builder = new StringBuilder();
        Map<String, T> components = composite.getComponents();
        Iterator<Map.Entry<String, T>> iterator = components.entrySet().iterator();
        if (iterator.hasNext()) {
            this.renderComponent(builder, "", iterator.next());
        }
        while (iterator.hasNext()) {
            builder.append(", ");
            this.renderComponent(builder, "", iterator.next());
        }
        return builder.toString();
    }

    private <T> String renderComponentsHierarchical(Composite<T> composite, String indent) {
        String lineSeparator = SystemInfo.getLineSeparator();
        StringBuilder builder = new StringBuilder();
        indent = indent + INDENT_DELTA;
        Map<String, T> components = composite.getComponents();
        Iterator<Map.Entry<String, T>> iterator = components.entrySet().iterator();
        while (iterator.hasNext()) {
            builder.append(lineSeparator);
            this.renderComponent(builder, indent, iterator.next());
        }
        indent = indent.substring(0, indent.length() - INDENT_DELTA.length());
        if (builder.length() > 1) {
            builder.append(lineSeparator);
        }
        return builder.toString();
    }

    void renderComponent(StringBuilder builder, String indent, Map.Entry<String, ? extends Object> component) {
        Date date;
        Object value;
        builder.append(indent);
        if (this.renderNames) {
            builder.append(component.getKey()).append('=');
        }
        value = (value = component.getValue()) == null ? this.nullValue : (value instanceof Date ? (TimeUtil.isMidnight(date = (Date)value) ? new SimpleDateFormat(this.datePattern).format((Date)value) : new SimpleDateFormat(this.timestampPattern).format((Date)value)) : (value instanceof Composite ? this.render("[", (Composite)value, "]") : (value.getClass().isArray() ? "[" + ToStringConverter.convert(value, "null") + "]" : ToStringConverter.convert(value, "null"))));
        builder.append(value);
    }
}

