/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.Arrays;

public class CustomCounter {
    private int radix;
    private int[] digits;
    private boolean overrun;

    public CustomCounter(int radix, int length) {
        this.radix = radix;
        this.digits = new int[length];
        this.overrun = false;
        Arrays.fill(this.digits, 0);
    }

    public int[] getDigits() {
        return this.digits;
    }

    private char mapDigit(int digit) {
        if (digit <= 9) {
            return (char)(48 + digit);
        }
        return (char)(97 + digit - 10);
    }

    public void increment() {
        this.incrementDigit(0);
    }

    public boolean hasOverrun() {
        return this.overrun;
    }

    public String toString() {
        char[] tmp = new char[this.digits.length];
        for (int i = 0; i < this.digits.length; ++i) {
            tmp[i] = this.mapDigit(this.digits[this.digits.length - 1 - i]);
        }
        return new String(tmp);
    }

    private void incrementDigit(int i) {
        if (i >= this.digits.length) {
            this.overrun = true;
            return;
        }
        if (this.digits[i] < this.radix - 1) {
            int n = i;
            this.digits[n] = this.digits[n] + 1;
        } else {
            this.digits[i] = 0;
            if (i < this.digits.length - 1) {
                this.incrementDigit(i + 1);
            } else {
                this.overrun = true;
            }
        }
    }
}

