/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.SystemInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandler {
    private Log logger;
    private Level level;
    private boolean loggingStackTrace;

    public ErrorHandler(Class<?> category) {
        this(category.getName());
    }

    public ErrorHandler(String category) {
        this(category, Level.fatal);
    }

    public ErrorHandler(String category, Level level) {
        this.logger = LogFactory.getLog((String)category);
        this.level = level;
        this.loggingStackTrace = true;
    }

    public void handleError(String message) {
        switch (this.level) {
            case trace: {
                this.logger.trace((Object)message);
                break;
            }
            case debug: {
                this.logger.debug((Object)message);
                break;
            }
            case info: {
                this.logger.info((Object)message);
                break;
            }
            case warn: {
                this.logger.warn((Object)message);
                break;
            }
            case error: {
                this.logger.error((Object)message);
                break;
            }
            case fatal: {
                this.logger.fatal((Object)message);
                throw new RuntimeException(message);
            }
        }
    }

    public void handleError(String message, Throwable t) {
        if (this.loggingStackTrace) {
            switch (this.level) {
                case trace: {
                    this.logger.trace((Object)message);
                    break;
                }
                case debug: {
                    this.logger.debug((Object)message);
                    break;
                }
                case info: {
                    this.logger.info((Object)message);
                    break;
                }
                case warn: {
                    this.logger.warn((Object)message);
                    break;
                }
                case error: {
                    this.logger.error((Object)message, t);
                    break;
                }
                case fatal: {
                    this.logger.fatal((Object)message, t);
                    throw new RuntimeException(t);
                }
            }
        } else {
            this.handleError(message + SystemInfo.getLineSeparator() + t.toString());
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isLoggingStackTrace() {
        return this.loggingStackTrace;
    }

    public void setLoggingStackTrace(boolean loggingStackTrace) {
        this.loggingStackTrace = loggingStackTrace;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        ignore,
        trace,
        debug,
        info,
        warn,
        error,
        fatal;

    }
}

