/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.databene.commons.ConfigurationError;

public final class ExceptionMapper {
    public static ConfigurationError configurationException(Exception cause, Constructor constructor) {
        String message = cause instanceof IllegalAccessException ? "No access to constructor: " + constructor : (cause instanceof InvocationTargetException ? "Internal exception in constructor: " + constructor : (cause instanceof InstantiationException ? "Error in instantiation by constructor: " + constructor : cause.getMessage()));
        return new ConfigurationError(message, cause);
    }

    public static ConfigurationError configurationException(Exception cause, Method method) {
        String message = cause instanceof IllegalAccessException ? "No access to method: " + method : (cause instanceof InvocationTargetException ? "Internal exception in method: " + method : (cause instanceof IntrospectionException ? "Internal exception in method: " + method : cause.getMessage()));
        return new ConfigurationError(message, cause);
    }

    public static ConfigurationError configurationException(Exception cause, Class type) {
        String message = cause instanceof IntrospectionException ? "Introspection failed for class " + type : (cause instanceof InstantiationException ? "Instantiation failed for class '" + type + "' Possibly it is abstract, the constructor not public, or no appropriate constructor is provided." : (cause instanceof IllegalAccessException ? "Constructor not accessible for class " + type : cause.getMessage()));
        return new ConfigurationError(message, cause);
    }

    public static ConfigurationError configurationException(Exception cause, Field field) {
        String message = cause instanceof IllegalAccessException ? "No access to field: " + field : (cause instanceof NoSuchFieldException ? "No such field found: " + field : cause.getMessage());
        return new ConfigurationError(message, cause);
    }

    public static ConfigurationError configurationException(Exception cause, String name) {
        String message = cause instanceof ClassNotFoundException ? "Class not found: '" + name + "'" : (cause instanceof NoSuchFieldException ? "Field not found: '" + name + "'" : (cause instanceof NoSuchMethodException ? "Method not found: '" + name + "'" : cause.getMessage()));
        return new ConfigurationError(message, cause);
    }
}

