/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;

public final class FileUtil {
    public static void ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            File parent = directory.getParentFile();
            if (parent != null) {
                FileUtil.ensureDirectoryExists(parent);
            }
            directory.mkdir();
        }
    }

    public static boolean hasSuffix(File file, String suffix, boolean caseSensitive) {
        if (caseSensitive) {
            return file.getName().endsWith(suffix);
        }
        return file.getName().toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static String suffix(File file) {
        return FileUtil.suffix(file.getName());
    }

    public static String suffix(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex < 0 || dotIndex == filename.length() - 1) {
            return "";
        }
        return filename.substring(dotIndex + 1);
    }

    public static String nativePath(String path) {
        return path.replace('/', SystemInfo.getFileSeparator());
    }

    public static boolean isEmptyFolder(File folder) {
        String[] list = folder.list();
        return list == null || list.length == 0;
    }

    public static void copy(File srcFile, File targetFile, boolean overwrite) throws FileNotFoundException, IOException {
        FileUtil.copy(srcFile, targetFile, overwrite, null);
    }

    public static void copy(File srcFile, File targetFile, boolean overwrite, FileFilter filter) throws FileNotFoundException, IOException {
        if (filter != null && !filter.accept(srcFile.getCanonicalFile())) {
            return;
        }
        if (!srcFile.exists()) {
            throw new ConfigurationError("Source file not found: " + srcFile);
        }
        if (!overwrite && targetFile.exists()) {
            throw new ConfigurationError("Target file already exists: " + targetFile);
        }
        if (srcFile.isFile()) {
            FileUtil.copyFile(srcFile, targetFile);
        } else {
            FileUtil.copyDirectory(srcFile, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File srcFile, File targetFile) throws FileNotFoundException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(targetFile);
            IOUtil.transfer(in, out);
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close(out);
        IOUtil.close(in);
    }

    private static void copyDirectory(File srcDirectory, File targetDirectory) throws FileNotFoundException, IOException {
        FileUtil.ensureDirectoryExists(targetDirectory);
        for (File src : srcDirectory.listFiles()) {
            File dstFile = new File(targetDirectory, src.getName());
            FileUtil.copy(src, dstFile, true);
        }
    }
}

