/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.OrderedMap;
import org.databene.commons.ParseUtil;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.collection.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtil {
    private static final Log logger = LogFactory.getLog(IOUtil.class);
    private static final String USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 5.1; de-DE; rv:1.7.5) Gecko/20041122 Firefox/1.0";

    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void flush(OutputStream stream) {
        if (stream != null) {
            try {
                stream.flush();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void flush(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static String localFilename(String uri) {
        String[] path = uri.split("/");
        return path[path.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isURIAvailable(String uri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("isURIAvailable(" + uri + ')'));
        }
        InputStream stream = null;
        try {
            if (uri.startsWith("string://")) {
                boolean bl = true;
                return bl;
            }
            if (uri.startsWith("http://")) {
                boolean bl = IOUtil.httpUrlAvailable(uri);
                return bl;
            }
            if (uri.startsWith("file:") && !uri.startsWith("file://")) {
                stream = IOUtil.getFileOrResourceAsStream(uri.substring("file:".length()), false);
            } else {
                if (!uri.contains("://")) {
                    uri = "file://" + uri;
                }
                if (uri.startsWith("file://")) {
                    stream = IOUtil.getFileOrResourceAsStream(uri.substring("file://".length()), false);
                }
            }
            boolean bl = stream != null;
            IOUtil.close(stream);
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtil.close(stream);
        }
    }

    public static String getContentOfURI(String uri) throws IOException {
        BufferedReader reader = IOUtil.getReaderForURI(uri);
        StringWriter writer = new StringWriter();
        IOUtil.transfer(reader, writer);
        return writer.toString();
    }

    public static String[] readTextLines(String uri, boolean includeEmptyLines) throws IOException {
        String line;
        ArrayBuilder<String> builder = new ArrayBuilder<String>(String.class, 100);
        BufferedReader reader = IOUtil.getReaderForURI(uri);
        while ((line = reader.readLine()) != null) {
            if (line.length() <= 0 && !includeEmptyLines) continue;
            builder.append(line.trim());
        }
        return builder.toArray();
    }

    public static BufferedReader getReaderForURI(String uri) throws IOException {
        return IOUtil.getReaderForURI(uri, SystemInfo.getFileEncoding());
    }

    public static BufferedReader getReaderForURI(String uri, String defaultEncoding) throws IOException {
        if (uri.startsWith("string://")) {
            return new BufferedReader(new StringReader(uri.substring("string://".length())));
        }
        if (uri.startsWith("http://")) {
            return IOUtil.getHttpReader(uri, defaultEncoding);
        }
        return IOUtil.getFileReader(uri, defaultEncoding);
    }

    public static InputStream getInputStreamForURI(String uri) throws IOException {
        return IOUtil.getInputStreamForURI(uri, true);
    }

    public static InputStream getInputStreamForURI(String uri, boolean required) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getInputStreamForURI(" + uri + ", " + required + ')'));
        }
        if (uri.startsWith("string://")) {
            String content = uri.substring("string://".length());
            return new ByteArrayInputStream(content.getBytes(SystemInfo.getCharset()));
        }
        if (uri.startsWith("http://")) {
            try {
                URLConnection connection = IOUtil.getConnection(uri);
                return connection.getInputStream();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (uri.startsWith("file:") && !uri.startsWith("file://")) {
            return IOUtil.getFileOrResourceAsStream(uri.substring("file:".length()), true);
        }
        if (!uri.contains("://")) {
            uri = "file://" + uri;
        }
        if (uri.startsWith("file://")) {
            return IOUtil.getFileOrResourceAsStream(uri.substring("file://".length()), true);
        }
        if (required) {
            throw new ConfigurationError("Don't know how to handle URL " + uri);
        }
        return null;
    }

    public static InputStream getInputStreamForUriReference(String localUri, String contextUri, boolean required) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getInputStreamForUriReference(" + localUri + ", " + contextUri + ')'));
        }
        if (StringUtil.isEmpty(contextUri) || IOUtil.getProtocol(localUri) != null) {
            return IOUtil.getInputStreamForURI(localUri, required);
        }
        String uri = IOUtil.resolveLocalUri(localUri, contextUri);
        if (localUri.startsWith("http://")) {
            try {
                URLConnection connection = IOUtil.getConnection(uri);
                return connection.getInputStream();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (localUri.startsWith("file:") && !localUri.startsWith("file://")) {
            return IOUtil.getFileOrResourceAsStream(localUri.substring("file:".length()), true);
        }
        if (!localUri.contains("://")) {
            localUri = "file://" + localUri;
        }
        if (localUri.startsWith("file://")) {
            return IOUtil.getFileOrResourceAsStream(localUri.substring("file://".length()), true);
        }
        throw new ConfigurationError("Don't know how to handle URL " + localUri);
    }

    public static String resolveLocalUri(String localUri, String contextUri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resolveLocalUri(" + localUri + ", " + contextUri + ')'));
        }
        if (StringUtil.isEmpty(contextUri) || IOUtil.getProtocol(localUri) != null) {
            return localUri;
        }
        String protocol = IOUtil.getProtocol(contextUri);
        try {
            File file;
            URL contextUrl = new URL((protocol == null ? "file:" : "") + contextUri);
            URL absoluteUrl = new URL(contextUrl, localUri);
            String result = absoluteUrl.toString();
            if (protocol == null) {
                result = result.substring(5);
            }
            if (!"./".equals(contextUri) && (protocol == null || protocol.startsWith("file:")) && !(file = new File(result)).exists() && IOUtil.isURIAvailable(localUri)) {
                result = localUri;
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getContextUri(String uri) {
        char systemSeparator;
        if (StringUtil.isEmpty(uri)) {
            return null;
        }
        String protocol = IOUtil.getProtocol(uri);
        if (protocol != null) {
            uri = uri.substring(protocol.length());
        }
        char uriSeparator = uri.indexOf(systemSeparator = SystemInfo.getFileSeparator()) >= 0 ? systemSeparator : (char)'/';
        String contextUri = StringUtil.splitOnLastSeparator(uri, uriSeparator)[0] + uriSeparator;
        if (protocol != null) {
            contextUri = protocol + contextUri;
        }
        return contextUri;
    }

    public static String getProtocol(String uri) {
        if (uri == null) {
            return null;
        }
        int sep = uri.indexOf("://");
        return sep > 0 ? uri.substring(0, sep) : null;
    }

    public static PrintWriter getPrinterForURI(String uri, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        return IOUtil.getPrinterForURI(uri, encoding, false, SystemInfo.getLineSeparator());
    }

    public static PrintWriter getPrinterForURI(String uri, String encoding, boolean append, final String lineSeparator) throws FileNotFoundException, UnsupportedEncodingException {
        return new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(uri, append), encoding)){

            public void println() {
                this.print(lineSeparator);
            }
        };
    }

    public static int transfer(Reader reader, Writer writer) throws IOException {
        int charsRead;
        int totalChars = 0;
        char[] buffer = new char[16384];
        while ((charsRead = reader.read(buffer, 0, buffer.length)) > 0) {
            writer.write(buffer, 0, charsRead);
            totalChars += charsRead;
        }
        return totalChars;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int charsRead;
        int totalChars = 0;
        byte[] buffer = new byte[16384];
        while ((charsRead = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, charsRead);
            totalChars += charsRead;
        }
        return totalChars;
    }

    public static void copy(String srcUri, String targetUri) throws IOException {
        logger.info((Object)("downloading " + srcUri + " --> " + targetUri));
        InputStream in = IOUtil.getInputStreamForURI(srcUri);
        FileOutputStream out = new FileOutputStream(targetUri);
        IOUtil.transfer(in, out);
        ((OutputStream)out).close();
        in.close();
    }

    public static Map<String, String> readProperties(String filename) throws IOException {
        return IOUtil.readProperties(filename, SystemInfo.getFileEncoding());
    }

    public static Map<String, String> readProperties(String filename, String encoding) throws IOException {
        return IOUtil.readProperties(new OrderedMap(), filename, null, encoding);
    }

    public static <V> Map<String, V> readProperties(String filename, Converter<Map.Entry, Map.Entry> converter) throws IOException {
        return IOUtil.readProperties(filename, converter, SystemInfo.getFileEncoding());
    }

    public static <V> Map<String, V> readProperties(String filename, Converter<Map.Entry, Map.Entry> converter, String encoding) throws IOException {
        return IOUtil.readProperties(new OrderedMap(), filename, converter, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <M extends Map> M readProperties(M target, String filename, Converter<Map.Entry, Map.Entry> converter, String encoding) throws IOException {
        BufferedReader reader = null;
        ReaderLineIterator iterator = null;
        try {
            reader = IOUtil.getReaderForURI(filename, encoding);
            iterator = new ReaderLineIterator(reader);
            String key = null;
            String value = "";
            while (iterator.hasNext()) {
                String line = iterator.next();
                if ((line = line.trim()).startsWith("#")) continue;
                line = StringUtil.unescape(line);
                if (key != null) {
                    value = value + IOUtil.normalizeLine(line);
                } else {
                    String[] assignment = ParseUtil.parseAssignment(line, "=", false);
                    if (assignment == null || assignment[1] == null) continue;
                    key = assignment[0];
                    value = IOUtil.normalizeLine(assignment[1]);
                }
                if (line.endsWith("\\")) continue;
                if (converter != null) {
                    Map.Entry<String, String> entry = new MapEntry<String, String>(key, value);
                    entry = converter.convert(entry);
                    target.put((String)entry.getKey(), (String)entry.getValue());
                } else {
                    target.put((String)key, (String)value);
                }
                key = null;
                value = "";
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            } else {
                IOUtil.close(reader);
            }
        }
        return target;
    }

    private static String normalizeLine(String line) {
        return line.endsWith("\\") ? line.substring(0, line.length() - 1) : line;
    }

    public static void writeProperties(Properties properties, String filename) throws IOException {
        IOUtil.writeProperties(properties, filename, SystemInfo.getFileEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(Properties properties, String filename, String encoding) throws IOException {
        PrintWriter stream = null;
        try {
            stream = IOUtil.getPrinterForURI(filename, encoding);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                stream.println(entry.getKey() + "=" + entry.getValue());
            }
        }
        finally {
            IOUtil.close(stream);
        }
    }

    public static void writeTextFile(String filename, String content) throws IOException {
        IOUtil.writeTextFile(filename, content, SystemInfo.getFileEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(String filename, String content, String encoding) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding);
            IOUtil.transfer(new StringReader(content), writer);
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close(writer);
    }

    private static InputStream getFileOrResourceAsStream(String filename, boolean required) throws FileNotFoundException {
        File file;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getFileOrResourceAsStream(" + filename + ", " + required + ')'));
        }
        if ((file = new File(filename)).exists()) {
            return new FileInputStream(filename);
        }
        return IOUtil.getResourceAsStream(filename, required);
    }

    private static InputStream getResourceAsStream(String name, boolean required) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getResourceAsStream(" + name + ", " + required + ')'));
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        InputStream stream = IOUtil.class.getResourceAsStream(name);
        if (required && stream == null) {
            throw new ConfigurationError("Resource not found: " + name);
        }
        return stream;
    }

    private static boolean httpUrlAvailable(String urlString) {
        try {
            URL url = new URL(urlString);
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static URLConnection getConnection(String uri) throws IOException {
        URLConnection connection = new URL(uri).openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.connect();
        return connection;
    }

    public static byte[] getBinaryContentOfUri(String uri) throws IOException {
        InputStream in = IOUtil.getInputStreamForURI(uri);
        ByteArrayOutputStream out = new ByteArrayOutputStream(25000);
        IOUtil.transfer(in, out);
        return out.toByteArray();
    }

    private static BufferedReader getFileReader(String filename, String defaultEncoding) throws IOException, UnsupportedEncodingException {
        if (defaultEncoding == null) {
            defaultEncoding = SystemInfo.getFileEncoding();
        }
        InputStream is = IOUtil.getInputStreamForURI(filename);
        PushbackInputStream in = new PushbackInputStream(is, 4);
        defaultEncoding = IOUtil.bomEncoding(in, defaultEncoding);
        return new BufferedReader(new InputStreamReader((InputStream)in, defaultEncoding));
    }

    private static BufferedReader getHttpReader(String url, String defaultEncoding) throws IOException, UnsupportedEncodingException {
        try {
            URLConnection connection = IOUtil.getConnection(url);
            connection.connect();
            String encoding = IOUtil.encoding(connection, defaultEncoding);
            InputStream inputStream = connection.getInputStream();
            return new BufferedReader(new InputStreamReader(inputStream, encoding));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String encoding(URLConnection connection, String defaultEncoding) {
        int i;
        String ct;
        String encoding = connection.getContentEncoding();
        if (StringUtil.isEmpty(encoding) && !StringUtil.isEmpty(ct = connection.getHeaderField("Content-Type")) && (i = ct.indexOf("charset")) >= 0) {
            encoding = ct.substring(i + "charset".length() + 1).trim();
        }
        if (StringUtil.isEmpty(encoding)) {
            encoding = defaultEncoding;
        }
        if (StringUtil.isEmpty(encoding)) {
            encoding = SystemInfo.getFileEncoding();
        }
        return encoding;
    }

    private static String bomEncoding(PushbackInputStream in, String defaultEncoding) throws IOException {
        int b1 = in.read();
        if (b1 == -1) {
            return defaultEncoding;
        }
        if (b1 != 239) {
            in.unread(b1);
            return defaultEncoding;
        }
        int b2 = in.read();
        if (b2 == -1) {
            in.unread(b1);
            return defaultEncoding;
        }
        if (b2 != 187) {
            in.unread(b2);
            in.unread(b1);
            return defaultEncoding;
        }
        int b3 = in.read();
        if (b3 == -1) {
            in.unread(b2);
            in.unread(b1);
            return defaultEncoding;
        }
        if (b3 != 191) {
            in.unread(b3);
            in.unread(b2);
            in.unread(b1);
            return defaultEncoding;
        }
        return "UTF-8";
    }
}

