/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.databene.commons.ArrayFormat;
import org.databene.commons.CharSet;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaleUtil {
    private static final Locale FALLBACK_LOCALE = Locale.US;
    private static Map<Locale, Set<Character>> specialLetters;

    public static Set<Character> letters(Locale locale) {
        Set<Character> set = LocaleUtil.nullTolerantLetters(locale);
        if (set == null) {
            throw new UnsupportedOperationException("Locale not supported: " + locale);
        }
        return set;
    }

    public static Locale parent(Locale locale) {
        String variant = locale.getVariant();
        if (!StringUtil.isEmpty(variant)) {
            if (variant.contains("_")) {
                String[] variantPath = StringUtil.tokenize(variant, '_');
                variant = ArrayFormat.formatPart("_", 0, variantPath.length - 1, variantPath);
                return new Locale(locale.getLanguage(), locale.getCountry(), variant);
            }
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!StringUtil.isEmpty(locale.getCountry())) {
            return new Locale(locale.getLanguage());
        }
        return null;
    }

    public static Locale getFallbackLocale() {
        return FALLBACK_LOCALE;
    }

    public static Locale getLocale(String code) {
        if (StringUtil.isEmpty(code)) {
            throw new IllegalArgumentException("code is empty");
        }
        String[] path = StringUtil.tokenize(code, '_');
        switch (path.length) {
            case 1: {
                return new Locale(path[0]);
            }
            case 2: {
                return new Locale(path[0], path[1]);
            }
            case 3: {
                return new Locale(path[0], path[1], path[2]);
            }
        }
        return new Locale(path[0], path[1], ArrayFormat.formatPart("_", 2, path.length - 2, path));
    }

    public static String availableLocaleUrl(String baseName, Locale locale, String suffix) {
        String localeString = locale.toString();
        do {
            String url = baseName;
            if (!StringUtil.isEmpty(localeString)) {
                url = url + "_" + localeString;
            }
            if (!IOUtil.isURIAvailable(url = url + suffix)) continue;
            return url;
        } while ((localeString = LocaleUtil.reduceLocaleString(localeString)) != null);
        return null;
    }

    private static String reduceLocaleString(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return null;
        }
        int separatorIndex = localeString.lastIndexOf(95);
        if (separatorIndex < 0) {
            return "";
        }
        return localeString.substring(0, separatorIndex);
    }

    public static String getDefaultCountryCode() {
        String result = Locale.getDefault().getCountry();
        if (StringUtil.isEmpty(result)) {
            result = LocaleUtil.getFallbackLocale().getCountry();
        }
        return result;
    }

    private static Set<Character> nullTolerantLetters(Locale locale) {
        if (locale == null) {
            return null;
        }
        Set<Character> set = specialLetters.get(locale);
        if (set != null) {
            return set;
        }
        Locale parent = locale;
        while ((parent = LocaleUtil.parent(parent)) != null) {
            set = specialLetters.get(parent);
            if (set == null) continue;
            return set;
        }
        return LocaleUtil.latinSet();
    }

    private static void readConfigFile() {
        try {
            specialLetters = new HashMap<Locale, Set<Character>>();
            Map<String, String> properties = IOUtil.readProperties("org/databene/commons/special-letters.properties", "UTF-8");
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                Locale locale = LocaleUtil.getLocale(String.valueOf(entry.getKey()));
                String specialChars = String.valueOf(entry.getValue());
                Set<Character> charSet = LocaleUtil.latinSet();
                for (int i = 0; i < specialChars.length(); ++i) {
                    charSet.add(Character.valueOf(specialChars.charAt(i)));
                }
                specialLetters.put(locale, charSet);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Setup file for locale-specific letters is missing", e);
        }
    }

    private static Set<Character> latinSet() {
        return new CharSet('A', 'Z').addRange('a', 'z').getSet();
    }

    static {
        LocaleUtil.readConfigFile();
    }
}

