/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.Comparator;
import org.databene.commons.ComparableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullSafeComparator<E>
implements Comparator<E> {
    public static final int NULL_IS_LESSER = -1;
    public static final int NULL_IS_GREATER = 1;
    private Comparator<E> realComparator;
    private int nullComparation;

    public NullSafeComparator() {
        this(new ComparableComparator());
    }

    public NullSafeComparator(int nullComparation) {
        this(new ComparableComparator(), nullComparation);
    }

    public NullSafeComparator(Comparator realComparator) {
        this(realComparator, -1);
    }

    public NullSafeComparator(Comparator realComparator, int nullComparation) {
        this.realComparator = realComparator;
        this.nullComparation = nullComparation;
    }

    @Override
    public int compare(E o1, E o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return o2 == null ? 0 : this.nullComparation;
        }
        if (o2 == null) {
            return -this.nullComparation;
        }
        return this.realComparator.compare(o1, o2);
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2, int nullComparation) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return o2 == null ? 0 : nullComparation;
        }
        if (o2 == null) {
            return -nullComparation;
        }
        return o1.compareTo(o2);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }
}

