/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import org.databene.commons.StringUtil;

public class NumberUtil {
    public static final int MAX_WIDTH = 12;
    private static NumberFormat defaultNumberFormat = NumberFormat.getInstance(Locale.US);
    private static HashMap fixWidthFormats;

    public static String formatHex(int value, int digits) {
        String tmp = Integer.toHexString(value);
        if (tmp.length() > digits) {
            return tmp.substring(tmp.length() - digits, tmp.length());
        }
        return StringUtil.padLeft(tmp, digits, '0');
    }

    public static int bitsUsed(long value) {
        if (value < 0L) {
            return 64;
        }
        for (int i = 62; i > 0; --i) {
            if ((value >> i & 1L) != 1L) continue;
            return i + 1;
        }
        return 1;
    }

    public static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    public static String format(double number) {
        return defaultNumberFormat.format(number);
    }

    public static String format(double number, int digits) {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMinimumFractionDigits(digits);
        nf.setMaximumFractionDigits(digits);
        return nf.format(number);
    }

    public static String formatZeroPadded(int number, int digits) {
        NumberFormat nf = (NumberFormat)fixWidthFormats.get(new Integer(digits));
        return nf.format(number);
    }

    static {
        defaultNumberFormat.setMinimumFractionDigits(2);
        defaultNumberFormat.setMaximumFractionDigits(2);
        fixWidthFormats = new HashMap();
        StringBuilder buffer = new StringBuilder("0");
        for (int i = 1; i < 12; ++i) {
            DecimalFormat format = new DecimalFormat(buffer.toString());
            fixWidthFormats.put(new Integer(i), format);
            buffer.append('0');
        }
    }
}

