/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.collection.ListBasedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<K, V>
implements Map<K, V> {
    private Map<K, Integer> keyIndices;
    protected List<V> values;

    public OrderedMap() {
        this.keyIndices = new HashMap<K, Integer>();
        this.values = new ArrayList<V>();
    }

    public OrderedMap(int initialCapacity) {
        this.keyIndices = new HashMap<K, Integer>(initialCapacity);
        this.values = new ArrayList<V>(initialCapacity);
    }

    public OrderedMap(int initialCapacity, float loadFactor) {
        this.keyIndices = new HashMap<K, Integer>(initialCapacity, loadFactor);
        this.values = new ArrayList<V>(initialCapacity);
    }

    public OrderedMap(Map<K, V> source) {
        this(source.size());
        for (Map.Entry<K, V> entry : source.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyIndices.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        Integer index = this.keyIndices.get(key);
        if (index == null) {
            return null;
        }
        return this.values.get(index);
    }

    @Override
    public V put(K key, V value) {
        Integer index = this.keyIndices.get(key);
        if (index != null) {
            return this.values.set(index, value);
        }
        this.keyIndices.put(key, this.values.size());
        this.values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        Integer index = this.keyIndices.remove(key);
        if (index != null) {
            V oldValue = this.values.get(index);
            this.values.remove(index);
            for (Map.Entry<K, Integer> entry : this.keyIndices.entrySet()) {
                int entryIndex = entry.getValue();
                if (entryIndex <= index) continue;
                entry.setValue(entryIndex - 1);
            }
            return oldValue;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keyIndices.clear();
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        ArrayList<K> tmp = new ArrayList<K>(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            tmp.add(null);
        }
        for (Map.Entry<K, Integer> entry : this.keyIndices.entrySet()) {
            tmp.set(entry.getValue(), entry.getKey());
        }
        return new ListBasedSet(tmp);
    }

    @Override
    public List<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map.Entry[] tmp = new Map.Entry[this.values.size()];
        for (Map.Entry<K, Integer> entry : this.keyIndices.entrySet()) {
            Integer index = entry.getValue();
            tmp[index.intValue()] = new ProxyEntry(entry.getKey(), index);
        }
        return new ListBasedSet<Map.Entry<K, V>>(tmp);
    }

    public V elementAt(int index) {
        return this.values.get(index);
    }

    public Object[] toArray() {
        return this.values.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.values.toArray(a);
    }

    public boolean equalsIgnoreOrder(Map<K, V> that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (this.size() != that.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : that.entrySet()) {
            K key = entry.getKey();
            if (!this.containsKey(key)) {
                return false;
            }
            if (NullSafeComparator.equals(this.get(key), that.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedMap that = (OrderedMap)o;
        return ((Object)this.values).equals(that.values) && ((Object)this.keyIndices).equals(that.keyIndices);
    }

    @Override
    public int hashCode() {
        return ((Object)this.keyIndices).hashCode() * 29 + ((Object)this.values).hashCode();
    }

    public String toString() {
        ListBasedSet entries = (ListBasedSet)this.entrySet();
        StringBuilder buffer = new StringBuilder("{");
        if (entries.size() > 0) {
            buffer.append(entries.get(0));
        }
        for (int i = 1; i < entries.size(); ++i) {
            buffer.append(", ").append(entries.get(i));
        }
        buffer.append('}');
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProxyEntry
    implements Map.Entry<K, V> {
        private K key;
        private int index;

        public ProxyEntry(K key, int index) {
            this.key = key;
            this.index = index;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return OrderedMap.this.values.get(this.index);
        }

        @Override
        public V setValue(V value) {
            return OrderedMap.this.values.set(this.index, value);
        }

        public String toString() {
            return String.valueOf(this.key) + '=' + this.getValue();
        }
    }
}

