/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.databene.commons.OrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedSet<E>
implements Set<E> {
    private OrderedMap<E, E> map;

    public OrderedSet() {
        this.map = new OrderedMap();
    }

    public OrderedSet(int initialCapacity) {
        this.map = new OrderedMap(initialCapacity);
    }

    public OrderedSet(int initialCapacity, float loadFactor) {
        this.map = new OrderedMap(initialCapacity, loadFactor);
    }

    public OrderedSet(Collection<E> source) {
        this.map = new OrderedMap(source.size());
        this.addAll(source);
    }

    @Override
    public boolean add(E item) {
        return this.map.put(item, item) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> source) {
        boolean changed = false;
        for (E item : source) {
            changed |= this.add(item);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object item) {
        return this.map.containsKey(item);
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        for (Object o : items) {
            if (this.map.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object item) {
        return this.map.remove(item) != null;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        boolean changed = false;
        for (Object item : items) {
            changed |= this.remove(item);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        boolean changed = false;
        for (E item : this.map.keySet()) {
            if (items.contains(item)) continue;
            this.map.remove(item);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.map.keySet().toArray(array);
    }

    public E get(int index) {
        return this.map.elementAt(index);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.map.equals(((OrderedSet)obj).map);
    }

    public String toString() {
        return this.map.toString();
    }
}

