/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParseUtil {
    public static double parseDecimal(PushbackReader reader) throws IOException, ParseException {
        double result = ParseUtil.parseInteger(reader);
        double postfix = ParseUtil.parseOptionalPostfix(reader);
        result = result >= 0.0 ? (result += postfix) : (result -= postfix);
        return result;
    }

    public static double parseOptionalPostfix(PushbackReader reader) throws IOException {
        int c = reader.read();
        if (c != 46) {
            if (c != -1) {
                reader.unread(c);
            }
            return 0.0;
        }
        double result = 0.0;
        double base = 0.1;
        while ((c = reader.read()) != -1 && Character.isDigit((char)c)) {
            result += (double)(c - 48) * base;
            base *= 0.1;
        }
        if (c != -1) {
            reader.unread(c);
        }
        return result;
    }

    public static long parseInteger(PushbackReader reader) throws IOException, ParseException {
        boolean negative = ParseUtil.parseOptionalSign(reader);
        return ParseUtil.parseNonNegativeInteger(reader) * (long)(negative ? -1 : 1);
    }

    public static long parseNonNegativeInteger(String source, ParsePosition pos) throws ParseException {
        char digit;
        if (pos.getIndex() > source.length() || !Character.isDigit((int)(digit = source.charAt(pos.getIndex())))) {
            throw new ParseException("Number expected", 0);
        }
        pos.setIndex(pos.getIndex() + 1);
        long result = digit - 48;
        while (pos.getIndex() < source.length() && Character.isDigit((int)(digit = source.charAt(pos.getIndex())))) {
            result = result * 10L + (long)digit - 48L;
            pos.setIndex(pos.getIndex() + 1);
        }
        return result;
    }

    public static long parseNonNegativeInteger(PushbackReader reader) throws IOException, ParseException {
        int digit = reader.read();
        if (digit == -1 || !Character.isDigit((char)digit)) {
            throw new ParseException("Long expected", 0);
        }
        long result = digit - 48;
        while ((digit = reader.read()) != -1 && Character.isDigit((char)digit)) {
            result = result * 10L + (long)digit - 48L;
        }
        if (digit != -1) {
            reader.unread(digit);
        }
        return result;
    }

    public static boolean parseOptionalSign(PushbackReader reader) throws IOException {
        ParseUtil.skipWhitespace(reader);
        int optionalSign = reader.read();
        if (optionalSign == 45) {
            return true;
        }
        if (optionalSign != -1) {
            reader.unread(optionalSign);
        }
        return false;
    }

    public static void skipWhitespace(PushbackReader reader) throws IOException {
        int c;
        while ((c = reader.read()) != -1 && Character.isWhitespace((char)c)) {
        }
        if (c != -1) {
            reader.unread(c);
        }
    }

    public static String parseUnit(PushbackReader reader) throws IOException {
        int c;
        StringBuilder result = new StringBuilder();
        while ((c = reader.read()) != -1 && Character.isUpperCase((char)c)) {
            result.append((char)c);
        }
        if (c != -1) {
            reader.unread(c);
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public static boolean parseEstimated(PushbackReader reader) throws IOException {
        int c = reader.read();
        if (c == 101) {
            return true;
        }
        if (c != -1) {
            reader.unread(c);
        }
        return false;
    }

    public static boolean isEmpty(Object object) {
        return object == null || StringUtil.isEmpty((String)object);
    }

    public static int nextNonWhitespaceIndex(String source, int startIndex) {
        int i;
        for (i = startIndex; i < source.length() && Character.isWhitespace(source.charAt(i)); ++i) {
        }
        if (i >= source.length()) {
            i = -1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] parseEmptyLineSeparatedFile(Reader src) throws IOException {
        String[][] stringArray;
        BufferedReader reader = null;
        ArrayList<List<String>> sections = new ArrayList<List<String>>();
        ArrayList<String> lines = null;
        try {
            String line;
            reader = new BufferedReader(src);
            while ((line = reader.readLine()) != null) {
                if (line.length() > 0) {
                    if (lines == null) {
                        lines = new ArrayList<String>();
                        sections.add(lines);
                    }
                    lines.add(line);
                    continue;
                }
                if (lines != null) {
                    lines = null;
                    continue;
                }
                sections.add(new ArrayList());
            }
            stringArray = StringUtil.toArrayArray(sections);
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(reader);
        return stringArray;
    }

    public static Object[] splitNumbers(String text) {
        ArrayList<Object> parts = new ArrayList<Object>();
        Boolean numMode = null;
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean newMode = Character.isDigit(c);
            if (numMode != null && newMode != numMode) {
                String partString = text.substring(start, i);
                ParseUtil.addPart(partString, parts, numMode);
                start = i;
            }
            numMode = newMode;
        }
        ParseUtil.addPart(text.substring(start), parts, numMode);
        return parts.toArray();
    }

    public static boolean isPositiveNumber(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String from(String s, String separator) {
        return ParseUtil.from(s, separator, null);
    }

    public static String from(String s, String separator, String notFoundValue) {
        int separatorIndex = s.indexOf(separator);
        return separatorIndex >= 0 ? s.substring(separatorIndex) : notFoundValue;
    }

    public static String before(String s, String separator) {
        int separatorIndex = s.indexOf(separator);
        return separatorIndex >= 0 ? s.substring(0, separatorIndex) : s;
    }

    public static boolean isHex(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (ParseUtil.isHex(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    public static String[] parseAssignment(String line, String operator, boolean lhsRequired) {
        if (line == null) {
            return null;
        }
        int sep = line.indexOf(operator);
        if (sep < 0 || lhsRequired && sep == 0) {
            return null;
        }
        return new String[]{line.substring(0, sep).trim(), sep < line.length() - 1 ? line.substring(sep + 1).trim() : null};
    }

    public static boolean isNMToken(String testName) {
        if (testName == null || testName.length() == 0) {
            return false;
        }
        char c = testName.charAt(0);
        if (!Character.isLetter(c) && c != '_' && c != ':') {
            return false;
        }
        for (int i = 1; i < testName.length(); ++i) {
            c = testName.charAt(i);
            if (Character.isLetter(c) || c == '.' || c == '-' || c == '_' || c == ':') continue;
            return false;
        }
        return true;
    }

    private static void addPart(String partString, List<Object> parts, Boolean numMode) {
        Object part = numMode != false ? new BigInteger(partString) : partString;
        parts.add(part);
    }
}

