/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period
implements Comparable<Period> {
    private static SortedSet<Period> instances = new TreeSet<Period>();
    public static final Period MILLISECOND = new Period(1L, "ms");
    public static final Period SECOND = new Period(1000L, "s");
    public static final Period MINUTE = new Period(60000L, "m");
    public static final Period HOUR = new Period(3600000L, "h");
    public static final Period DAY = new Period(86400000L, "d");
    public static final Period WEEK = new Period(604800000L, "w");
    public static final Period MONTH = new Period(30L * Period.DAY.millis, "M");
    public static final Period QUARTER = new Period(3L * Period.MONTH.millis, "M");
    public static final Period YEAR = new Period(365L * Period.DAY.millis, "y");
    private long millis;
    private String name;

    private Period(long millis, String name) {
        this.millis = millis;
        this.name = name;
        instances.add(this);
    }

    public long getMillis() {
        return this.millis;
    }

    public String getName() {
        return this.name;
    }

    public static List<Period> getInstances() {
        return new ArrayList<Period>(instances);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.millis == ((Period)o).millis;
    }

    public int hashCode() {
        return (int)(this.millis ^ this.millis >>> 32);
    }

    @Override
    public int compareTo(Period that) {
        if (this.millis > that.millis) {
            return 1;
        }
        if (this.millis < that.millis) {
            return -1;
        }
        return 0;
    }

    public static Period minInstance() {
        return instances.first();
    }

    public static Period maxInstance() {
        return instances.last();
    }
}

