/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderLineIterator
implements HeavyweightIterator<String> {
    private BufferedReader reader;
    private String next;
    private int lineCount;

    public ReaderLineIterator(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.lineCount = 0;
        this.fetchNext();
    }

    @Override
    public void close() {
        if (this.reader != null) {
            IOUtil.close(this.reader);
            this.reader = null;
        }
    }

    public int lineCount() {
        return this.lineCount;
    }

    @Override
    public boolean hasNext() {
        return this.reader != null && this.next != null;
    }

    @Override
    public String next() {
        String result = this.next;
        this.fetchNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    private void fetchNext() {
        try {
            if (this.reader != null) {
                this.next = this.reader.readLine();
                if (this.next == null) {
                    this.close();
                }
                ++this.lineCount;
            } else {
                this.next = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

