/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ErrorHandler;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.SystemInfo;

public class ShellUtil {
    public static int runShellCommands(ReaderLineIterator iterator, ErrorHandler errorHandler) {
        int result = 0;
        while (iterator.hasNext()) {
            String command = iterator.next().trim();
            if (command.length() <= 0) continue;
            result = ShellUtil.runShellCommand(command, errorHandler);
        }
        return result;
    }

    public static int runShellCommand(String command, ErrorHandler errorHandler) {
        return ShellUtil.runShellCommand(command, new File(SystemInfo.getCurrentDir()), errorHandler);
    }

    public static int runShellCommand(String command, File directory, ErrorHandler errorHandler) {
        try {
            String s = null;
            Process p = Runtime.getRuntime().exec(command, null, directory);
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdIn.readLine()) != null) {
                System.out.println(s);
            }
            while ((s = stdErr.readLine()) != null) {
                System.out.println(s);
            }
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue != 0) {
                errorHandler.handleError("Process (" + command + ") did not terminate normally: Return code " + exitValue);
            }
            return exitValue;
        }
        catch (FileNotFoundException e) {
            errorHandler.handleError("Error in shell invocation: " + command, e);
            return 2;
        }
        catch (Exception e) {
            errorHandler.handleError("Error in shell invocation: " + command, e);
            return 1;
        }
    }

    public static void runShellCommand(String[] cmdArray, File directory, ErrorHandler errorHandler) {
        try {
            String s = null;
            Process p = Runtime.getRuntime().exec(cmdArray, null, directory);
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdIn.readLine()) != null) {
                System.out.println(s);
            }
            while ((s = stdErr.readLine()) != null) {
                System.out.println(s);
            }
            p.waitFor();
            if (p.exitValue() != 0) {
                String command = ArrayFormat.format(" ", cmdArray);
                errorHandler.handleError("Process (" + command + ") did not terminate normally: Return code " + p.exitValue());
            }
        }
        catch (Exception e) {
            String command = ArrayFormat.format(" ", cmdArray);
            errorHandler.handleError("Error in shell invocation: " + command, e);
        }
    }
}

