/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import org.databene.commons.CharacterIterator;
import org.databene.commons.ParseException;

public class StringCharacterIterator
implements CharacterIterator {
    private String source;
    private int index;
    private int line;
    private int column;
    private int lastLineLength;

    public StringCharacterIterator(String source) {
        this(source, 0);
    }

    public StringCharacterIterator(String source, int index) {
        if (source == null) {
            throw new IllegalArgumentException("source string must not be null");
        }
        this.source = source;
        this.index = index;
        this.line = 1;
        this.column = 1;
        this.lastLineLength = 1;
    }

    public boolean hasNext() {
        return this.index < this.source.length();
    }

    public char next() {
        if (this.index >= this.source.length()) {
            throw new IllegalStateException("Reached the end of the string");
        }
        if (this.source.charAt(this.index) == '\n') {
            this.lastLineLength = this.column;
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        return this.source.charAt(this.index++);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public char peekNext() {
        if (!this.hasNext()) {
            return '\u0000';
        }
        return this.source.charAt(this.index);
    }

    public void pushBack() {
        if (this.index > 0) {
            if (this.index - 1 < this.source.length() && this.source.charAt(this.index - 1) == '\n') {
                --this.line;
                this.column = this.lastLineLength;
            } else {
                --this.column;
            }
            --this.index;
        } else {
            throw new IllegalStateException("cannot pushBack before start of string: " + this.source);
        }
    }

    public int index() {
        return this.index;
    }

    public void skipWhitespace() {
        while (this.index < this.source.length() && Character.isWhitespace(this.source.charAt(this.index))) {
            ++this.index;
        }
    }

    public String parseLetters() {
        StringBuilder builder = new StringBuilder();
        while (this.index < this.source.length() && Character.isLetter(this.source.charAt(this.index))) {
            builder.append(this.source.charAt(this.index++));
        }
        return builder.toString();
    }

    public String remainingText() {
        return this.source.substring(this.index);
    }

    public String substring(int from, int to) {
        return this.source.substring(from, to);
    }

    public String parsedSubstring(int from) {
        return this.source.substring(from, this.index);
    }

    public void assertNext(char c) {
        if (!this.hasNext()) {
            throw new ParseException("Expected '" + c + "', but no more character is available", this.line, this.column);
        }
        char next = this.next();
        if (next != c) {
            throw new ParseException("Expected '" + c + "', but found '" + next + "'", this.line, this.column);
        }
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public String toString() {
        return this.source;
    }
}

