/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.databene.commons.StringCharacterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtil {
    private static final String CR = String.valueOf('\r');
    private static final String LF = String.valueOf('\n');
    private static final String TAB = String.valueOf('\t');
    private static final int BUFFER_SIZE = 1024;
    private static char[] WHITESPACE_BUFFER = new char[1024];

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String suffix(String name, char separator) {
        if (name == null) {
            return null;
        }
        int separatorIndex = name.lastIndexOf(separator);
        if (separatorIndex < 0 || separatorIndex == name.length() - 1) {
            return null;
        }
        return name.substring(separatorIndex + 1);
    }

    public static String lastToken(String name, char separator) {
        if (name == null) {
            return null;
        }
        int separatorIndex = name.lastIndexOf(separator);
        if (separatorIndex < 0) {
            return name;
        }
        if (separatorIndex == name.length() - 1) {
            return null;
        }
        return name.substring(separatorIndex + 1);
    }

    public static String[] tokenize(String text, char separator) {
        int sep;
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return new String[]{""};
        }
        int i = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((sep = text.indexOf(separator, i)) >= 0) {
            if (sep == i) {
                list.add("");
                ++i;
                continue;
            }
            list.add(text.substring(i, sep));
            i = sep + 1;
        }
        if (i < text.length()) {
            list.add(text.substring(i));
        } else if (text.endsWith("" + separator)) {
            list.add("");
        }
        String[] tokens = new String[list.size()];
        for (i = 0; i < tokens.length; ++i) {
            tokens[i] = (String)list.get(i);
        }
        return tokens;
    }

    public static String normalize(String s) {
        char[] srcBuffer = new char[s.length()];
        s.getChars(0, s.length(), srcBuffer, 0);
        char[] dstBuffer = new char[s.length()];
        int dstIndex = 0;
        for (char c : srcBuffer) {
            if (c < '\u0010') continue;
            dstBuffer[dstIndex++] = c;
        }
        return new String(dstBuffer, 0, dstIndex);
    }

    public static StringBuilder appendLeftAligned(StringBuilder builder, String text, int columns) {
        builder.append(text);
        int columnsToInsert = columns - text.length();
        for (int i = 0; i < columnsToInsert; ++i) {
            builder.append(' ');
        }
        return builder;
    }

    public static String increment(String text) {
        if (text == null || text.length() == 0) {
            return "0";
        }
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        chars = StringUtil.increment(chars, chars.length - 1);
        return String.valueOf(chars);
    }

    public static char[] increment(char[] chars, int index) {
        char c = chars[index];
        switch (c) {
            case '9': {
                chars[index] = 97;
                break;
            }
            case 'Z': 
            case 'z': {
                if (index > 0) {
                    chars[index] = 48;
                    chars = StringUtil.increment(chars, index - 1);
                    break;
                }
                char[] result = new char[chars.length + 1];
                Arrays.fill(result, '0');
                result[0] = 49;
                return result;
            }
            default: {
                int n = index;
                chars[n] = (char)(chars[n] + '\u0001');
            }
        }
        return chars;
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || c == '\u00a0';
    }

    public static String trim(String s) {
        int endIndex;
        int beginIndex;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (beginIndex = 0; beginIndex < s.length() && StringUtil.isWhitespace(s.charAt(beginIndex)); ++beginIndex) {
        }
        for (endIndex = s.length() - 1; endIndex > 0 && StringUtil.isWhitespace(s.charAt(endIndex)); --endIndex) {
        }
        if (beginIndex > endIndex) {
            return "";
        }
        return s.substring(beginIndex, endIndex + 1);
    }

    public static void trimAll(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtil.trim(array[i]);
        }
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static boolean contains(String s, char c) {
        return s.indexOf(c) >= 0;
    }

    public static String remove(String s, String chars) {
        if (s == null) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.contains(chars, s.charAt(i))) continue;
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    public static String normalizeSpace(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if ((s = StringUtil.trim(s)).length() == 0) {
            return s;
        }
        char lastChar = s.charAt(0);
        StringBuilder result = new StringBuilder().append(lastChar);
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(lastChar) || !Character.isWhitespace(c)) {
                result.append(c);
            }
            lastChar = c;
        }
        return result.toString();
    }

    public static String trimEnd(String s) {
        int lastIndex;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (lastIndex = s.length() - 1; lastIndex >= 0 && StringUtil.isWhitespace(s.charAt(lastIndex)); --lastIndex) {
        }
        if (lastIndex < 0) {
            return "";
        }
        return s.substring(0, lastIndex + 1);
    }

    public static int countChars(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String[] toArray(List<String> list) {
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static String[][] toArrayArray(List<List<String>> list) {
        String[][] result = new String[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = StringUtil.toArray(list.get(i));
        }
        return result;
    }

    public static String padLeft(String text, int length, char c) {
        int textLength;
        if (text == null) {
            text = "";
        }
        if ((textLength = text.length()) > length) {
            throw new IllegalArgumentException("Text is too long (" + textLength + ") to be padded to " + length + " columns");
        }
        char[] chars = new char[length];
        int offset = length - textLength;
        StringUtil.fill(chars, 0, offset, c);
        StringUtil.getChars(0, textLength, text, chars, offset);
        return new String(chars);
    }

    public static String padRight(String text, int length, char c) {
        int textLength;
        if (text == null) {
            text = "";
        }
        if ((textLength = text.length()) > length) {
            throw new IllegalArgumentException("Text is too long (" + textLength + ") to be padded to " + length + " columns");
        }
        char[] chars = new char[length];
        StringUtil.fill(chars, textLength, length, c);
        StringUtil.getChars(0, textLength, text, chars, 0);
        return new String(chars);
    }

    public static void fill(char[] chars, int fromIndex, int toIndex, char c) {
        int length = toIndex - fromIndex;
        if (length < 20) {
            for (int i = fromIndex; i < toIndex; ++i) {
                chars[i] = c;
            }
        } else if (c != ' ' || length > WHITESPACE_BUFFER.length) {
            Arrays.fill(chars, fromIndex, toIndex, c);
        } else {
            System.arraycopy(WHITESPACE_BUFFER, 0, chars, fromIndex, length);
        }
    }

    public static char[] getChars(int srcBegin, int srcEnd, String text, char[] chars, int dstBegin) {
        int textLength = text.length();
        if (textLength >= 6) {
            text.getChars(srcBegin, srcEnd, chars, dstBegin);
        } else {
            for (int i = 0; i < textLength; ++i) {
                chars[i + dstBegin] = text.charAt(i);
            }
        }
        return chars;
    }

    public static char[] getChars(String s) {
        char[] chars = new char[s.length()];
        return StringUtil.getChars(0, chars.length, s, chars, 0);
    }

    public static char[] getChars(StringBuilder builder) {
        char[] chars = new char[builder.length()];
        builder.getChars(0, builder.length(), chars, 0);
        return chars;
    }

    public static String padString(char c, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative pad length: " + length);
        }
        char[] chars = new char[length];
        Arrays.fill(chars, 0, length, c);
        return new String(chars);
    }

    public static String trimRight(String source, char padChar) {
        int i;
        if (source == null) {
            return null;
        }
        for (i = source.length() - 1; i >= 0 && source.charAt(i) == padChar; --i) {
        }
        return source.substring(0, i + 1);
    }

    public static String trimLeft(String source, char padChar) {
        int i;
        if (source == null) {
            return null;
        }
        for (i = 0; i < source.length() && source.charAt(i) == padChar; ++i) {
        }
        return source.substring(i, source.length());
    }

    public static Object trim(String source, char padChar) {
        int i1;
        int i0;
        if (source == null) {
            return null;
        }
        for (i0 = 0; i0 < source.length() && source.charAt(i0) == padChar; ++i0) {
        }
        if (i0 == source.length()) {
            return "";
        }
        for (i1 = source.length() - 1; i1 > i0 && source.charAt(i1) == padChar; --i1) {
        }
        return source.substring(i0, i1 + 1);
    }

    public static String[] toLowerCase(String[] src) {
        String[] dst = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i].toLowerCase();
        }
        return dst;
    }

    public static int indexOfIgnoreCase(String searched, String ... candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (!searched.equalsIgnoreCase(candidates[i])) continue;
            return i;
        }
        return -1;
    }

    public static char lastChar(String word) {
        return word.charAt(word.length() - 1);
    }

    public static String capitalize(String text) {
        return text.substring(0, 1).toUpperCase() + text.substring(1);
    }

    public static String uncapitalize(String text) {
        return text.substring(0, 1).toLowerCase() + text.substring(1);
    }

    public static String[] splitOnFirstSeparator(String path, char separator) {
        if (path == null) {
            return new String[]{null, null};
        }
        int sepIndex = path.indexOf(separator);
        return StringUtil.splitAroundSeparator(path, sepIndex);
    }

    public static String[] splitOnLastSeparator(String path, char separator) {
        if (path == null) {
            return new String[]{null, null};
        }
        int sepIndex = path.lastIndexOf(separator);
        return StringUtil.splitAroundSeparator(path, sepIndex);
    }

    public static String[] splitAroundSeparator(String path, int sepIndex) {
        if (sepIndex < 0) {
            return new String[]{null, path};
        }
        if (sepIndex == 0) {
            return new String[]{"", path.substring(1)};
        }
        if (sepIndex == path.length() - 1) {
            return new String[]{path.substring(0, path.length() - 1), ""};
        }
        return new String[]{path.substring(0, sepIndex), path.substring(sepIndex + 1)};
    }

    public static String joinWithSeparator(char separator, String ... parts) {
        if (parts == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (StringUtil.isEmpty(part)) continue;
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(part);
        }
        return builder.toString();
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 != null ? s1.equalsIgnoreCase(s2) : s2 == null;
    }

    public static boolean containsIgnoreCase(Collection<String> names, String searched) {
        for (String name : names) {
            if (!name.equalsIgnoreCase(searched)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text == null) {
            return prefix == null;
        }
        if (prefix == null) {
            return false;
        }
        return text.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean endsWithIgnoreCase(String text, String suffix) {
        if (text == null) {
            return suffix == null;
        }
        if (suffix == null) {
            return false;
        }
        return text.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static String normalizeName(String name) {
        int NONE = -1;
        boolean WS = false;
        boolean INITIAL = true;
        int SUBSEQUENT = 2;
        StringBuilder builder = new StringBuilder(name.length());
        StringCharacterIterator iterator = new StringCharacterIterator(name);
        iterator.skipWhitespace();
        int prevType = -1;
        while (iterator.hasNext()) {
            char c = iterator.next();
            int type = Character.isWhitespace(c) ? 0 : (prevType == 1 ? 2 : (prevType == -1 || prevType == 0 ? 1 : prevType));
            if (prevType == 0 && type == 1) {
                builder.append(' ');
            }
            switch (type) {
                case 1: {
                    builder.append(Character.toUpperCase(c));
                    break;
                }
                case 2: {
                    builder.append(Character.toLowerCase(c));
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error");
                }
            }
            prevType = type;
        }
        return builder.toString();
    }

    public static String escape(String text) {
        return StringUtil.escape(text, false, false);
    }

    public static String escape(String text, boolean escapeSingleQuotes, boolean escapeDoubleQuotes) {
        if (text == null) {
            return null;
        }
        text = text.replace("\\", "\\\\");
        text = text.replace(CR, "\\r");
        text = text.replace(LF, "\\n");
        text = text.replace(TAB, "\\t");
        if (escapeSingleQuotes) {
            text = text.replace("'", "\\'");
        }
        if (escapeDoubleQuotes) {
            text = text.replace("\"", "\\\"");
        }
        return text;
    }

    public static String unescape(String text) {
        if (text != null) {
            text = text.replace("\\r", CR);
            text = text.replace("\\n", LF);
            text = text.replace("\\t", TAB);
            text = text.replace("\\'", "'");
            text = text.replace("\\\"", "\"");
            text = text.replace("\\\\", "\\");
        }
        return text;
    }

    public static String replaceTokens(String src, String token, String ... values) {
        StringBuilder builder = new StringBuilder();
        int paramIndex = 0;
        int srcIndex = 0;
        while (srcIndex < src.length()) {
            int i = src.indexOf(token, srcIndex);
            if (i >= 0) {
                builder.append(src.substring(srcIndex, i));
                builder.append(values[paramIndex++]);
                srcIndex = i + token.length();
                continue;
            }
            builder.append(src.substring(srcIndex));
            break;
        }
        return builder.toString();
    }

    public static String emptyToNull(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        String trimmed = StringUtil.trim(s);
        return trimmed.length() != 0 ? s : null;
    }

    public static String removeSection(String text, String beginMark, String endMark) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        int beginIndex = text.indexOf(beginMark);
        int endIndex = text.indexOf(endMark);
        if (beginIndex < 0 || endIndex < 0 || beginIndex + beginMark.length() > endIndex + endMark.length()) {
            return text;
        }
        return text.substring(0, beginIndex) + text.substring(endIndex + endMark.length());
    }

    static {
        for (int i = 0; i < WHITESPACE_BUFFER.length; ++i) {
            StringUtil.WHITESPACE_BUFFER[i] = 32;
        }
    }
}

