/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.nio.charset.Charset;

public final class SystemInfo {
    public static final String USER_LANGUAGE_KEY = "user.language";
    public static final String FILE_ENCODING_KEY = "file.encoding";
    public static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";
    public static final String USER_HOME_KEY = "user.home";
    public static final String USER_NAME_KEY = "user.name";
    public static final String USER_DIR_KEY = "user.dir";
    public static final String FILE_SEPARATOR_KEY = "file.separator";
    public static final String PATH_SEPARATOR_KEY = "path.separator";
    public static final String LINE_SEPARATOR_KEY = "line.separator";
    public static final String OS_VERSION_KEY = "os.version";
    public static final String OS_ARCH_KEY = "os.arch";
    public static final String OS_NAME_KEY = "os.name";
    private static final String MAC_OS_X = "Mac OS X";
    private static final String WINDOWS = "Windows";

    @Deprecated
    public static String osName() {
        return System.getProperty(OS_NAME_KEY);
    }

    public static String getOsName() {
        return System.getProperty(OS_NAME_KEY);
    }

    @Deprecated
    public static String osArchitecture() {
        return System.getProperty(OS_ARCH_KEY);
    }

    public static String getOsArchitecture() {
        return System.getProperty(OS_ARCH_KEY);
    }

    @Deprecated
    public static String osVersion() {
        return System.getProperty(OS_VERSION_KEY);
    }

    public static String getOsVersion() {
        return System.getProperty(OS_VERSION_KEY);
    }

    @Deprecated
    public static String lineSeparator() {
        return System.getProperty(LINE_SEPARATOR_KEY);
    }

    public static String getLineSeparator() {
        return System.getProperty(LINE_SEPARATOR_KEY);
    }

    @Deprecated
    public static String pathSeparator() {
        return System.getProperty(PATH_SEPARATOR_KEY);
    }

    public static String getPathSeparator() {
        return System.getProperty(PATH_SEPARATOR_KEY);
    }

    @Deprecated
    public static char fileSeparator() {
        return System.getProperty(FILE_SEPARATOR_KEY).charAt(0);
    }

    public static char getFileSeparator() {
        return System.getProperty(FILE_SEPARATOR_KEY).charAt(0);
    }

    @Deprecated
    public static String currentDir() {
        return System.getProperty(USER_DIR_KEY);
    }

    public static String getCurrentDir() {
        return System.getProperty(USER_DIR_KEY);
    }

    @Deprecated
    public static String userName() {
        return System.getProperty(USER_NAME_KEY);
    }

    public static String getUserName() {
        return System.getProperty(USER_NAME_KEY);
    }

    @Deprecated
    public static String userHome() {
        return System.getProperty(USER_HOME_KEY);
    }

    public static String getUserHome() {
        return System.getProperty(USER_HOME_KEY);
    }

    @Deprecated
    public static String tempDir() {
        return System.getProperty(JAVA_IO_TMPDIR_KEY);
    }

    public static String getTempDir() {
        return System.getProperty(JAVA_IO_TMPDIR_KEY);
    }

    @Deprecated
    public static String fileEncoding() {
        return System.getProperty(FILE_ENCODING_KEY);
    }

    public static String getFileEncoding() {
        return System.getProperty(FILE_ENCODING_KEY);
    }

    @Deprecated
    public static String userLanguage() {
        return System.getProperty(USER_LANGUAGE_KEY);
    }

    public static String getUserLanguage() {
        return System.getProperty(USER_LANGUAGE_KEY);
    }

    public static boolean isWindows() {
        return SystemInfo.getOsName().startsWith(WINDOWS);
    }

    public static boolean isMacOsx() {
        return SystemInfo.getOsName().startsWith(MAC_OS_X);
    }

    public static Charset getCharset() {
        return Charset.forName(SystemInfo.getFileEncoding());
    }
}

