/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class TimeUtil {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static DateFormat df = DateFormat.getDateInstance();
    private static DateFormat mdf = new SimpleDateFormat("MM/yy");

    public static int currentYear() {
        return new GregorianCalendar().get(1);
    }

    public static boolean isWeekend(Calendar day) {
        int dayOfWeek = day.get(7);
        return dayOfWeek == 7 || dayOfWeek == 1;
    }

    public static Calendar today() {
        Calendar today = Calendar.getInstance();
        today.set(14, 0);
        today.set(13, 0);
        today.set(12, 0);
        today.set(11, 0);
        return today;
    }

    public static Calendar yesterday() {
        Calendar result = TimeUtil.today();
        result.add(5, -1);
        return result;
    }

    public static Calendar tomorrow() {
        Calendar result = TimeUtil.yesterday();
        result.add(5, 1);
        return result;
    }

    public static Date date(int year, int month, int day) {
        return TimeUtil.calendar(year, month, day).getTime();
    }

    public static Date date(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) {
        return TimeUtil.calendar(year, month, day, hours, minutes, seconds, milliseconds).getTime();
    }

    public static Date date(long millis) {
        Date date = new Date();
        date.setTime(millis);
        return date;
    }

    public static Calendar calendar(int year, int month, int day) {
        return new GregorianCalendar(year, month, day);
    }

    public static Calendar calendar(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) {
        GregorianCalendar calendar = new GregorianCalendar(year, month, day, hours, minutes, seconds);
        calendar.set(14, milliseconds);
        return calendar;
    }

    public static Calendar calendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static GregorianCalendar gregorianCalendar(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static String formatDate(Date date) {
        return df.format(date);
    }

    public static Date max(Date date1, Date date2) {
        return date1.before(date2) ? date2 : date1;
    }

    public static Date min(Date date1, Date date2) {
        return date1.before(date2) ? date1 : date2;
    }

    public static boolean between(long test, long firstTime, long lastTime) {
        return test >= firstTime && test <= lastTime;
    }

    public static String formatMillis(long t) {
        Date date = new Date(t);
        return TimeUtil.formatDate(date);
    }

    public static String formatMonth(Calendar calendar) {
        return mdf.format(calendar.getTime());
    }

    public static int year(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Date add(Date date, int field, int i) {
        Calendar calendar = TimeUtil.calendar(date);
        calendar.add(field, i);
        return calendar.getTime();
    }

    public static int yearsBetween(Date from, Date until) {
        Calendar fromCalendar = TimeUtil.calendar(from);
        Calendar untilCalendar = TimeUtil.calendar(until);
        int years = untilCalendar.get(1) - fromCalendar.get(1);
        if (untilCalendar.get(6) < fromCalendar.get(6)) {
            --years;
        }
        return years;
    }

    public static Time time(int hour, int minute) {
        return TimeUtil.time(hour, minute, 0, 0);
    }

    public static Time time(int hour, int minute, int second) {
        return TimeUtil.time(hour, minute, second, 0);
    }

    public static Time time(int hour, int minute, int second, int millisecond) {
        return new Time((((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000L);
    }

    public static DateFormat createDefaultDateFormat() {
        return new SimpleDateFormat(DEFAULT_DATE_PATTERN);
    }

    public static boolean isMidnight(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(14) == 0 && cal.get(13) == 0 && cal.get(12) == 0 && cal.get(11) == 0;
    }

    public static Time currentTime() {
        GregorianCalendar now = new GregorianCalendar();
        return TimeUtil.time(now.get(10), now.get(12), now.get(13), now.get(14));
    }
}

