/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons;

import java.text.SimpleDateFormat;
import java.util.Date;

public class Timespan {
    private static SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    public Date startDate;
    public Date endDate;

    public Timespan(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public boolean overlaps(Timespan that) {
        return Timespan.intersection(this, that) != null;
    }

    public Long duration() {
        if (this.endDate != null && this.startDate != null) {
            return new Long(this.endDate.getTime() - this.startDate.getTime());
        }
        return null;
    }

    public boolean contains(Timespan that) {
        return !this.startDate.after(that.startDate) && !this.endDate.before(that.endDate);
    }

    public boolean contains(Date date) {
        return this.startDate.before(date) && this.endDate.after(date);
    }

    public static Timespan intersection(Timespan span1, Timespan span2) {
        Date startDate = span1.startDate;
        if (span1.startDate == null || span2.startDate != null && span1.startDate.before(span2.startDate)) {
            startDate = span2.startDate;
        }
        Date endDate = span1.endDate;
        if (span1.endDate == null || span2.endDate != null && span1.endDate.after(span2.endDate)) {
            endDate = span2.endDate;
        }
        if (startDate != null && endDate != null && !endDate.after(startDate)) {
            return null;
        }
        return new Timespan(startDate, endDate);
    }

    public static Timespan unite(Timespan span1, Timespan span2) {
        Date endDate;
        Date startDate = span1.startDate;
        if (startDate != null) {
            Date date2 = span2.startDate;
            if (date2 == null) {
                startDate = date2;
            } else if (date2.before(startDate)) {
                startDate = date2;
            }
        }
        if ((endDate = span1.endDate) != null) {
            Date date2 = span2.endDate;
            if (date2 == null) {
                endDate = date2;
            } else if (date2.after(endDate)) {
                endDate = date2;
            }
        }
        return new Timespan(startDate, endDate);
    }

    public String toString() {
        if (this.startDate != null) {
            if (this.endDate != null) {
                return sdf.format(this.startDate) + " - " + sdf.format(this.endDate);
            }
            return "since " + sdf.format(this.startDate);
        }
        if (this.endDate != null) {
            return "until " + sdf.format(this.endDate);
        }
        return "ever";
    }

    public int hashCode() {
        int result = this.endDate == null ? 0 : this.endDate.hashCode();
        return result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Timespan that = (Timespan)obj;
        if (this.endDate == null ? that.endDate != null : !this.endDate.equals(that.endDate)) {
            return false;
        }
        if (this.startDate == null) {
            return that.startDate == null;
        }
        return this.startDate.equals(that.startDate);
    }
}

